#include <TVout.h>
#include "font4x6.h"
#include "font6x8.h"
#include <PS2Keyboard.h>

const int DataPin = 8;
const int IRQpin =  3;

TVout TV;
PS2Keyboard keyboard;

void setup() {
  TV.begin(PAL,120,96);
  keyboard.begin(DataPin, IRQpin);
  
  TV.select_font(font4x6);
  TV.println("Z-80 Terminal Ready....");
  TV.delay(2500);
  TV.clear_screen();
  Serial.begin(9600);
}

void loop() {
  char c;
  if (Serial.available()) {
    c = Serial.read();
    TV.print(c);
  }
  
  if (keyboard.available()) {
    c = keyboard.read();
    Serial.write(c);
  }
}
