#include "DFRobotDFPlayerMini.h"
#include <SoftwareSerial.h>

SoftwareSerial softSerial(/*rx =*/11, /*tx =*/12);

DFRobotDFPlayerMini DFPlayer;

void soundInit()
{
  softSerial.begin(9600);
  Serial.println();
  Serial.println(F("DFRobot DFPlayer Mini Demo"));
  Serial.println(F("Initializing DFPlayer ... (May take 3~5 seconds)"));
  
  if (!DFPlayer.begin(softSerial, /*isACK = */true, /*doReset = */true)) {  //Use serial to communicate with mp3.
    Serial.println(F("Unable to begin:"));
    Serial.println(F("1.Please recheck the connection!"));
    Serial.println(F("2.Please insert the SD card!"));
    while(true){
      delay(0);
    } 
  } 
  Serial.println(F("DFPlayer Mini online."));
  
  DFPlayer.volume(100);  //Set volume value. From 0 to 100
}

void playFanfare() {
  DFPlayer.play(6);  //Play the first mp3
  delay(4000);
}

void announceSoundSet(int nr) {
  DFPlayer.play(nr);  //Play the first mp3
  delay(4000);
}

void announceGameEnd() {
  DFPlayer.play(4);  //Play the first mp3
  delay(5000);
}

void announceAllCardsOnBoard() {
  DFPlayer.play(5);  //Play the first mp3
  delay(4000);
}

void playSound(int nr) {
  Serial.print("Sound: ");
  Serial.println(nr);
  DFPlayer.play(nr+6+soundSet*18);  //Play the first mp3
  delay(100);
}
