/*
  Schrittmotor test
 */
 
boolean bitx1, bitx2;  // Zustand x-Motor
boolean bity1, bity2;  // Zustand y-Motor
boolean bitz1, bitz2;  // Zustand z-Motor

void setup() {      
  // X-Motor Outputs
  pinMode(6, OUTPUT);     
  pinMode(7, OUTPUT);     
  pinMode(8, OUTPUT);     
  pinMode(9, OUTPUT);     
  
  // Y-Motor Outputs
  pinMode(2, OUTPUT);     
  pinMode(3, OUTPUT);     
  pinMode(4, OUTPUT);     
  pinMode(5, OUTPUT);     

  // Z-Motor Outputs
  pinMode(13, OUTPUT);     
  pinMode(12, OUTPUT);     
  pinMode(11, OUTPUT);     
  pinMode(10, OUTPUT);     

  bitx1=0;  // X-Motor abschalten
  bitx2=0;

  bity1=0;  // Y-Motor abschalten
  bity2=0;

  bitz1=0;  // Z-Motor abschalten
  bitz2=0;

  On();
}

void loop() {
  oneStep(1,1,-1);
  delay(4);
}


void On() {    // Schaltet die Stepper in den aktiven Zustand
  bitx1=0;
  bitx2=1;
  bity1=0;
  bity2=1;
  bitz1=0;
  bitz2=1;
}

// oneStep führt einen Schritt auf einer oder mehreren Achsen aus
// -1 rückwärts
// 1  vorwärts
// 0  kein Schritt
void oneStep(int xDir, int yDir, int zDir) {
  boolean bx1,by1,bz1;
  
  bx1 = bitx1;   // Alten Zustand sichern
  by1 = bity1;  
  bz1 = bitz1;

  if (xDir == 1)  { bitx1 = !bitx2; bitx2 = bx1; }  // x-Motor
  if (xDir == -1) { bitx1 = bitx2;  bitx2 = !bx1; }
  
  if (yDir == 1)  { bity1 = !bity2; bity2 = by1; }  // y-Motor
  if (yDir == -1) { bity1 = bity2;  bity2 = !by1; }
  
  if (zDir == 1)  { bitz1 = !bitz2; bitz2 = bz1; }  // z-Motor
  if (zDir == -1) { bitz1 = bitz2;  bitz2 = !bz1; }

  digitalWrite(8, bitx1);  // x-Motor outputs setzen
  digitalWrite(9, !bitx1);
  digitalWrite(7, bitx2);
  digitalWrite(6, !bitx2);

  digitalWrite(4, bity1);  // y-Motor outputs setzen
  digitalWrite(5, !bity1);
  digitalWrite(3, bity2);
  digitalWrite(2, !bity2);
  
  digitalWrite(12, bitz1);  // z-Motor outputs setzen
  digitalWrite(13, !bitz1);
  digitalWrite(11, bitz2);
  digitalWrite(10, !bitz2);  

}
