/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Label;
import controlP5.TickMark;
import java.util.ArrayList;
import java.util.logging.Level;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;

public class Range
extends Controller<Range> {
    protected static final int HORIZONTAL = 0;
    protected static final int VERTICAL = 1;
    protected int _myDirection;
    protected float _myValuePosition;
    protected boolean isDragging;
    protected boolean isDraggable = true;
    protected boolean isFirstClick;
    protected Label _myHighValueLabel;
    protected float _myValueRange;
    protected boolean isMinHandle;
    protected boolean isMaxHandle;
    protected boolean isMoveHandle;
    protected float distanceHandle;
    protected int handleSize = 10;
    protected int minHandle = 0;
    protected int maxHandle = 0;
    protected int mr = 0;
    protected final ArrayList<TickMark> _myTickMarks = new ArrayList();
    protected boolean isShowTickMarks;
    protected boolean isSnapToTickMarks;
    public static int autoWidth = 99;
    public static int autoHeight = 9;
    public static PVector autoSpacing = new PVector(0.0f, 5.0f, 0.0f);
    public int alignValueLabel = 3;
    protected int _myColorTickMark = -1;
    private int mode = -1;

    public Range(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 100.0f, 0.0f, 100.0f, 0, 0, 99, 9);
        controlP5.register(controlP5.papplet, string, this);
    }

    @ControlP5.Invisible
    public Range(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myArrayValue = new float[]{f3, f4};
        this._myMin = f;
        this._myMax = f2;
        this._myValueRange = this._myMax - this._myMin;
        this.minHandle = (int)PApplet.map((float)f3, (float)this._myMin, (float)this._myMax, (float)this.handleSize, (float)(this.getWidth() - this.handleSize));
        this.maxHandle = (int)PApplet.map((float)f4, (float)this._myMin, (float)this._myMax, (float)this.handleSize, (float)(this.getWidth() - this.handleSize));
        this.mr = this.maxHandle - this.minHandle;
        this._myCaptionLabel = new Label(this.cp5, string).setColor(this.color.getCaptionLabel()).align(11, 3);
        this._myValueLabel = new Label(this.cp5, "" + this.adjustValue(this._myMin)).setColor(this.color.getValueLabel()).set("" + this.adjustValue(f3)).align(37, 3);
        this._myHighValueLabel = new Label(this.cp5, this.adjustValue(this._myMax)).setColor(this.color.getValueLabel()).set("" + this.adjustValue(f4)).align(39, 3);
        this._myValue = f3;
        this._myDirection = 0;
        this.update();
    }

    @Override
    public Range setColorValueLabel(int n) {
        this._myValueLabel.setColor(n);
        this._myHighValueLabel.setColor(n);
        return this;
    }

    @Override
    public Range setColorCaptionLabel(int n) {
        this._myCaptionLabel.setColor(n);
        return this;
    }

    public Range setHighValueLabel(String string) {
        this._myHighValueLabel.set(string);
        return this;
    }

    public Range setLowValueLabel(String string) {
        this._myValueLabel.set(string);
        return this;
    }

    @ControlP5.Invisible
    public Range setSliderMode(int n) {
        return this;
    }

    public Range setHandleSize(int n) {
        this.handleSize = n;
        this.setLowValue(this._myArrayValue[0], false);
        this.setHighValue(this._myArrayValue[1], false);
        this.mr = this.maxHandle - this.minHandle;
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Range updateInternalEvents(PApplet pApplet) {
        if (this.isVisible) {
            int n = this._myControlWindow.mouseX - this._myControlWindow.pmouseX;
            if (n == 0) {
                return this;
            }
            if (this.isMousePressed && !this.cp5.isAltDown()) {
                switch (this.mode) {
                    case 37: {
                        this.minHandle = PApplet.max((int)this.handleSize, (int)PApplet.min((int)this.maxHandle, (int)(this.minHandle + n)));
                        break;
                    }
                    case 39: {
                        this.maxHandle = PApplet.max((int)this.minHandle, (int)PApplet.min((int)(this.getWidth() - this.handleSize), (int)(this.maxHandle + n)));
                        break;
                    }
                    case 3: {
                        this.minHandle = PApplet.max((int)this.handleSize, (int)PApplet.min((int)(this.getWidth() - this.mr - this.handleSize), (int)(this.minHandle + n)));
                        this.maxHandle = PApplet.max((int)this.minHandle, (int)PApplet.min((int)(this.getWidth() - this.handleSize), (int)(this.minHandle + this.mr)));
                    }
                }
                this.update();
            }
        }
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        float f = Range.x(this._myParent.getAbsolutePosition()) + Range.x(this.position);
        float f2 = Range.y(this._myParent.getAbsolutePosition()) + Range.y(this.position);
        if ((float)this._myControlWindow.mouseY < f2 || (float)this._myControlWindow.mouseY > f2 + (float)this.getHeight()) {
            this.mode = -1;
            this.isMaxHandle = false;
            this.isMinHandle = false;
            return;
        }
        int n = (int)(f + (float)this.minHandle);
        int n2 = (int)(f + (float)this.maxHandle);
        if (this._myControlWindow.mouseX >= n - this.handleSize && this._myControlWindow.mouseX < n) {
            this.mode = 37;
            this.isMinHandle = true;
        } else if (this._myControlWindow.mouseX >= n2 && this._myControlWindow.mouseX < n2 + this.handleSize) {
            this.mode = 39;
            this.isMaxHandle = true;
        } else if (this._myControlWindow.mouseX > n && this._myControlWindow.mouseX < n2 && this.isDraggable) {
            this.mode = 3;
        }
    }

    @Override
    @ControlP5.Invisible
    public Range setValue(float f) {
        this._myValue = f;
        this.broadcast(5);
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Range update() {
        this._myArrayValue[0] = PApplet.map((float)this.minHandle, (float)this.handleSize, (float)(this.getWidth() - this.handleSize), (float)this._myMin, (float)this._myMax);
        this._myArrayValue[1] = PApplet.map((float)this.maxHandle, (float)this.handleSize, (float)(this.getWidth() - this.handleSize), (float)this._myMin, (float)this._myMax);
        this.mr = this.maxHandle - this.minHandle;
        this._myHighValueLabel.set(this.adjustValue(this._myArrayValue[1]));
        this._myValueLabel.set(this.adjustValue(this._myArrayValue[0]));
        return this.setValue(this._myValue);
    }

    @ControlP5.Invisible
    public Range setDraggable(boolean bl) {
        this.isDraggable = bl;
        this.isDragging = !bl ? false : this.isDragging;
        return this;
    }

    @Override
    public float[] getArrayValue() {
        return this._myArrayValue;
    }

    @Override
    public Range setArrayValue(float[] fArray) {
        this.setLowValue(fArray[0], false);
        this.setHighValue(fArray[1], false);
        return this.update();
    }

    @Override
    public Range setMin(float f) {
        this._myMin = f;
        this._myValueRange = this._myMax - this._myMin;
        return this.setLowValue(this._myArrayValue[0]);
    }

    @Override
    public Range setMax(float f) {
        this._myMax = f;
        this._myValueRange = this._myMax - this._myMin;
        return this.setHighValue(this._myArrayValue[1]);
    }

    public float getLowValue() {
        return this._myArrayValue[0];
    }

    public float getHighValue() {
        return this._myArrayValue[1];
    }

    @Override
    public Range setWidth(int n) {
        super.setWidth(n);
        return this;
    }

    @Override
    public Range setHeight(int n) {
        super.setHeight(n);
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleased() {
        this.isMoveHandle = false;
        this.isMaxHandle = false;
        this.isMinHandle = false;
        this.isDragging = false;
        this.mode = -1;
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    @Override
    @ControlP5.Invisible
    public void onLeave() {
        this.isMinHandle = false;
        this.isMaxHandle = false;
    }

    protected void setTickMarks() {
        System.out.println("Range Tickmarks not yet supported");
    }

    public Range setColorTickMark(int n) {
        this._myColorTickMark = n;
        return this;
    }

    public Range showTickMarks(boolean bl) {
        this.isShowTickMarks = bl;
        return this;
    }

    public Range snapToTickMarks(boolean bl) {
        this.isSnapToTickMarks = bl;
        System.out.println("Range Tickmarks not yet supported");
        return this;
    }

    @ControlP5.Invisible
    public TickMark getTickMark() {
        System.out.println("Range Tickmarks not yet supported");
        return null;
    }

    public ArrayList<TickMark> getTickMarks() {
        return this._myTickMarks;
    }

    public Range setNumberOfTickMarks(int n) {
        System.out.println("Range Tickmarks not yet supported");
        this._myTickMarks.clear();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this._myTickMarks.add(new TickMark(this));
            }
            this.showTickMarks(true);
            this.snapToTickMarks(true);
        } else {
            this.showTickMarks(false);
            this.snapToTickMarks(false);
        }
        this._myUnit = (this._myMax - this._myMin) / (float)(this.getWidth() > this.getHeight() ? this.getWidth() - 1 : this.getHeight() - 1);
        this.setLowValue(this._myArrayValue[0], false);
        this.setHighValue(this._myArrayValue[1], false);
        return this.update();
    }

    public Range setRange(float f, float f2) {
        this.setMin(f);
        this.setMax(f2);
        return this;
    }

    public Range setRangeValues(float f, float f2) {
        return this.setArrayValue(new float[]{f, f2});
    }

    private Range setLowValue(float f, boolean bl) {
        this._myArrayValue[0] = PApplet.max((float)this._myMin, (float)this.snapValue(f));
        this.minHandle = (int)PApplet.map((float)this._myArrayValue[0], (float)this._myMin, (float)this._myMax, (float)this.handleSize, (float)(this.getWidth() - this.handleSize));
        return bl ? this.update() : this;
    }

    public Range setLowValue(float f) {
        return this.setLowValue(f, true);
    }

    private Range setHighValue(float f, boolean bl) {
        this._myArrayValue[1] = PApplet.min((float)this._myMax, (float)this.snapValue(f));
        this.maxHandle = (int)PApplet.map((float)this._myArrayValue[1], (float)this._myMin, (float)this._myMax, (float)this.handleSize, (float)(this.getWidth() - this.handleSize));
        return bl ? this.update() : this;
    }

    public Range setHighValue(float f) {
        return this.setHighValue(f, true);
    }

    protected float snapValue(float f) {
        if (this.isMousePressed) {
            return f;
        }
        if (this.isSnapToTickMarks) {
            this._myValuePosition = (f - this._myMin) / this._myUnit;
            float f2 = PApplet.round((float)PApplet.map((float)this._myValuePosition, (float)0.0f, (float)(this._myDirection == 0 ? (float)this.getWidth() : (float)this.getHeight()), (float)0.0f, (float)(this._myTickMarks.size() - 1)));
            f = PApplet.map((float)f2, (float)0.0f, (float)(this._myTickMarks.size() - 1), (float)this._myMin, (float)this._myMax);
        }
        return f;
    }

    @Override
    @ControlP5.Invisible
    public Range updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new RangeView();
                break;
            }
            case 2: {
                this._myControllerView = new RangeSpriteView();
                break;
            }
            case 1: {
                this._myControllerView = new RangeImageView();
                break;
            }
        }
        return this;
    }

    @Override
    @ControlP5.Invisible
    public String toString() {
        return "type:\tRange\n" + super.toString();
    }

    @Deprecated
    public float lowValue() {
        return this.getLowValue();
    }

    @Deprecated
    public float highValue() {
        return this.getHighValue();
    }

    @Deprecated
    public float[] arrayValue() {
        return this._myArrayValue;
    }

    class RangeImageView
    implements ControllerView<Range> {
        RangeImageView() {
        }

        @Override
        public void display(PGraphics pGraphics, Range range) {
            ControlP5.logger().log(Level.INFO, "RangeImageDisplay not implemented.");
        }
    }

    class RangeView
    implements ControllerView<Range> {
        RangeView() {
        }

        @Override
        public void display(PGraphics pGraphics, Range range) {
            int n = Range.this.mode;
            float f = Controller.x(Range.this._myParent.getAbsolutePosition()) + Controller.x(Range.this.position);
            int n2 = (int)(f + (float)Range.this.minHandle);
            int n3 = (int)(f + (float)Range.this.maxHandle);
            if (Range.this.isInside() && n < 0) {
                if (Range.this._myControlWindow.mouseX >= n2 - Range.this.handleSize && Range.this._myControlWindow.mouseX < n2) {
                    n = 37;
                } else if (Range.this._myControlWindow.mouseX >= n3 && Range.this._myControlWindow.mouseX < n3 + Range.this.handleSize) {
                    n = 39;
                } else if (Range.this._myControlWindow.mouseX > n2 && Range.this._myControlWindow.mouseX < n3 && Range.this.isDraggable) {
                    n = 3;
                }
            }
            pGraphics.pushMatrix();
            pGraphics.fill(Range.this.color.getBackground());
            pGraphics.noStroke();
            pGraphics.rect(0.0f, 0.0f, (float)Range.this.getWidth(), (float)Range.this.getHeight());
            pGraphics.fill(n == 3 ? Range.this.color.getActive() : Range.this.color.getForeground());
            if (Range.this.isShowTickMarks) {
                int n4 = Range.this.handleSize / 2;
                pGraphics.rect((float)(Range.this.minHandle - n4), 0.0f, (float)(Range.this.mr + Range.this.handleSize), (float)Range.this.getHeight());
                pGraphics.fill(Range.this.isMinHandle || n == 37 ? Range.this.color.getActive() : Range.this.color.getForeground());
                pGraphics.triangle((float)(Range.this.minHandle - Range.this.handleSize), 0.0f, (float)Range.this.minHandle, 0.0f, (float)(Range.this.minHandle - n4), (float)Range.this.getHeight());
                pGraphics.fill(Range.this.isMaxHandle || n == 39 ? Range.this.color.getActive() : Range.this.color.getForeground());
                pGraphics.triangle((float)Range.this.maxHandle, 0.0f, (float)(Range.this.maxHandle + Range.this.handleSize), 0.0f, (float)(Range.this.maxHandle + n4), (float)Range.this.getHeight());
            } else {
                pGraphics.rect((float)Range.this.minHandle, 0.0f, (float)Range.this.mr, (float)Range.this.getHeight());
                pGraphics.fill(Range.this.isMinHandle || n == 37 ? Range.this.color.getActive() : Range.this.color.getForeground());
                pGraphics.rect((float)(Range.this.minHandle - Range.this.handleSize), 0.0f, (float)Range.this.handleSize, (float)Range.this.getHeight());
                pGraphics.fill(Range.this.isMaxHandle || n == 39 ? Range.this.color.getActive() : Range.this.color.getForeground());
                pGraphics.rect((float)Range.this.maxHandle, 0.0f, (float)Range.this.handleSize, (float)Range.this.getHeight());
            }
            if (Range.this.isLabelVisible) {
                Range.this._myCaptionLabel.draw(pGraphics, 0, 0, range);
                Range.this._myValueLabel.draw(pGraphics, 0, 0, range);
                Range.this._myHighValueLabel.draw(pGraphics, 0, 0, range);
            }
            pGraphics.popMatrix();
            if (Range.this.isShowTickMarks) {
                pGraphics.pushMatrix();
                float f2 = (Range.this.getWidth() - Range.this.handleSize) / (Range.this.getTickMarks().size() - 1);
                pGraphics.translate((float)(Range.this.handleSize / 2), (float)Range.this.getHeight());
                pGraphics.fill(Range.this._myColorTickMark);
                for (TickMark tickMark : Range.this.getTickMarks()) {
                    tickMark.draw(pGraphics);
                    pGraphics.translate(f2, 0.0f);
                }
                pGraphics.popMatrix();
            }
        }
    }

    class RangeSpriteView
    implements ControllerView<Range> {
        RangeSpriteView() {
        }

        @Override
        public void display(PGraphics pGraphics, Range range) {
            ControlP5.logger().log(Level.INFO, "RangeSpriteDisplay not available.");
        }
    }
}

