/**
 * <b>ControlP5basics</b><br />
 * The following example demonstrates the basic use of controlP5.<br />
 * After initializing controlP5 you can add controllers to controlP5.
 * Here we use three numberboxes, one slider and one textfield.
 * The numberbox with name numberboxC will trigger function numberboxC()
 * in the example below. Whenever controlP5 detects a function in your 
 * sketch that corresponds to the name of a controller, it will forward
 * an event to that function. Any event triggered by a controller 
 * will be forwarded to function controlEvent in your sketch. <br />
 * related examples ControlP5numberbox, ControlP5slider, ControlP5textfield<br />
 * by Andreas Schlegel 2010<br />
 * 
 */

import controlP5.*;

ControlP5 controlP5;

void setup() {
  size(400,380);
  frameRate(25);
  controlP5 = new ControlP5(this);
  controlP5.addTextfield("Profil Links",30,30,100,20).setId(1);
  controlP5.addTextfield("Profil Rechts",250,30,100,20).setId(2);

  controlP5.addTextfield("Tiefe Links",30,90,100,20).setId(3);
  controlP5.addTextfield("Tiefe Rechts",250,90,100,20).setId(4);
  controlP5.addTextfield("Anstellwinkel Links",30,130,100,20).setId(5);
  controlP5.addTextfield("Anstellwinkel Rechts",250,130,100,20).setId(6);
  
  controlP5.addTextfield("Pfeilungswinkel",140,220,100,20).setId(7);
  controlP5.addTextfield("Segmentbreite",140,270,100,20).setId(8);
  
  controlP5.addButton("Start",0,30,340,80,19).setId(9);
  controlP5.addButton("Cancel",255,150,340,80,19).setId(10);
  controlP5.addButton("Home",128,270,340,80,19).setId(11);
  
  
}

void draw() {
  background(100);
  fill(100);
  stroke(60);
  rect(10,10,160,180);
  rect(220,10,160,180);  
  rect(10,210,370,100);
}

public void numberboxC(int theValue) {
  println("### got an event from numberboxC : "+theValue);
}

public void controlEvent(ControlEvent theEvent) {
  println("got a control event from controller with id "+theEvent.controller().id());
  switch(theEvent.controller().id()) {
    case(1): // numberboxA
    println("der Wert ist "+(theEvent.controller().value()));
    break;
  }
}
