/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerDisplay;
import controlP5.ControllerGroup;
import processing.core.PApplet;

public class Bang
extends Controller {
    protected int cnt;
    protected int triggerId = 2;

    protected Bang(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, int n, int n2) {
        super(controlP5, controllerGroup, string, f, f2, n, n2);
        this._myValue = 1.0f;
    }

    protected void onEnter() {
        this.cnt = 0;
        this.isActive = true;
    }

    protected void onLeave() {
        this.isActive = false;
    }

    protected void mousePressed() {
        if (this.triggerId == 2) {
            this.cnt = -3;
            this.isActive = true;
            this.update();
        }
    }

    protected void mouseReleased() {
        if (this.triggerId == 1) {
            this.cnt = -3;
            this.isActive = true;
            this.update();
        }
    }

    protected void mouseReleasedOutside() {
        this.onLeave();
    }

    public void setTriggerEvent(int n) {
        this.triggerId = n;
    }

    public void setValue(float f) {
        this._myValue = f;
        this.broadcast(1);
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "bang");
    }

    public void updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myDisplay = new BangDisplay();
                break;
            }
            case 2: {
                this._myDisplay = new BangSpriteDisplay();
                break;
            }
            case 1: {
                this._myDisplay = new BangImageDisplay();
                break;
            }
        }
    }

    public String toString() {
        return "type:\tBang\n" + super.toString();
    }

    class BangImageDisplay
    implements ControllerDisplay {
        BangImageDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            if (Bang.this.isActive) {
                pApplet.image(Bang.this.availableImages[2] ? Bang.this.images[2] : Bang.this.images[0], 0.0f, 0.0f);
            } else {
                pApplet.image(Bang.this.availableImages[1] ? Bang.this.images[1] : Bang.this.images[0], 0.0f, 0.0f);
            }
            if (Bang.this.cnt < 0) {
                pApplet.image(Bang.this.availableImages[1] ? Bang.this.images[1] : Bang.this.images[0], 0.0f, 0.0f);
                ++Bang.this.cnt;
            }
            if (!Bang.this.isActive && Bang.this.cnt >= 0) {
                pApplet.image(Bang.this.images[0], 0.0f, 0.0f);
            }
        }
    }

    class BangDisplay
    implements ControllerDisplay {
        BangDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            if (Bang.this.isActive) {
                pApplet.fill(Bang.this.color.colorActive);
            } else {
                pApplet.fill(Bang.this.color.colorForeground);
            }
            if (Bang.this.cnt < 0) {
                pApplet.fill(Bang.this.color.colorForeground);
                ++Bang.this.cnt;
            }
            pApplet.rect(0.0f, 0.0f, (float)Bang.this.width, (float)Bang.this.height);
            if (Bang.this.isLabelVisible) {
                Bang.this._myCaptionLabel.draw(pApplet, 0, Bang.this.height + 4);
            }
        }
    }

    class BangSpriteDisplay
    implements ControllerDisplay {
        BangSpriteDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            if (Bang.this.isActive) {
                Bang.this.sprite.setState(1);
            } else {
                Bang.this.sprite.setState(0);
            }
            if (Bang.this.cnt < 0) {
                Bang.this.sprite.setState(0);
                ++Bang.this.cnt;
            }
            pApplet.fill(0);
            Bang.this.sprite.draw(pApplet);
        }
    }
}

