/* Arduino GameShield Aug 2014 - Ralf Stoffels
 * 
 * The Library supports two 5x8 (resulting in 10 x 8) dot matrix LED displays
 * Simple Game Graphics can be programmed just like on a PC in Processing 
 */

#ifndef GameShield_h
#define GameShield_h

#define X_SIZE 10
#define Y_SIZE 8


class GameShield
{
  public:
    GameShield();
    void clear();
    void update();
    void point(int x, int y, bool visible);
    int getKnob();
    bool buttonPressed();

  private:
      int xSize, ySize;   // The dimensions of the display
      int rowCounter;
      bool canvas[X_SIZE][Y_SIZE];    // The Dot-Matrix
};

#endif
