<?php

/***************************************************************
* 
* Fledermaus-Anzeige
* 
* Ralf Stoffels - 2022
*
* Zeigt die empfangenen Spektraldaten des 
* LoRaWAN-Fledermausscanners grafisch an.
***************************************************************/

if(array_key_exists('clear', $_POST)) {
    clearFFT();
}

$HTML = "<!DOCTYPE html>\n";
$HTML .= "<html> \n <head> \n";
$HTML .= "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n";
$HTML .= "<div style=\"background-color:\"#fff\"; border-color:\"#888\">\n";
$HTML .= "<h1>Frequenzspektrum LoRaWAN-Fledermausscanner #001</h1>\n";
$f=fopen("fft.txt","r");
$date_of_update = fgets($f, 4096);
$volt = fgets($f, 4096);
$HTML .= "<h3>Letzter Update: ".$date_of_update."</h3>\n";
$volt = $volt/10;
$HTML .= "<h3>Akkuspannung: ".$volt."V</h3>\n";
$HTML .= "<h3>Frequenzsprektrum in kHz</h3>\n";
fclose($f);

$HTML .= "<svg width=\"100%\" height=\"25em\">\n";

$HTML .= "<rect x=\"0\" y=\"0\" width=\"100%\" height=\"90%\" stroke=\"#000\" stroke-width=\"1px\" fill=\"#ffffff\"></rect>\n";

for ($i=0; $i < 100; $i+=5) {
    $HTML .= "<line x1=\"".$i."%\" y1=\"1\" x2=\"".$i."%\" y2=\"90%\" stroke=\"#4c4b84\" stroke-width=\"0.3\" />\n"; 
    $val = 1024*$i/1000;
    $HTML .= "<text x=\"".$i."%\" y=\"95%\" fill=\"black\">".$val."</text>\n"; 
}

for ($i=0; $i < 100; $i+=10) { 
    $HTML .= "<line y1=\"".$i."%\" x1=\"1\" y2=\"".$i."%\" x2=\"100%\"stroke=\"#4c4b84\" stroke-width=\"0.3\" />\n";
}

$f=fopen("fft.txt","r");
$count=0;

if ($f) { 
   $first_line = fgets($f, 4096);    # die ersten beiden Zeilen enthalten keine FFT Daten
   $first_line = fgets($f, 4096);
   while (($fft[$count] = fgets($f, 4096)) !== false) $count++; 
}
fclose($f);

$xval_n0=0;
$signal_n0 = 90-$fft[0]; 

for ($i=1; $i<$count; $i++) {
   $xval = $i*100/1024;
   $signal = 90-$fft[$i]; 
   $HTML .= "<line x1=\"".$xval_n0."%\" y1=\"".$signal_n0."%\" x2=\"".$xval."%\" y2=\"".$signal."%\" stroke=\"#0000FF\" stroke-width=\"3\" />\n"; 
   $xval_n0 = $xval;
   $signal_n0 = $signal;
}

$HTML .= "</svg> </div>\n"; 

$HTML .= "<form method=\"post\">";
$HTML .= "<input type=\"submit\" name=\"clear\" class=\"button\" value=\"Clear\" style=\"color: red; margin: 1em \"/>";
$HTML .= "<input type=\"submit\" name=\"update\" class=\"button\" value=\"Update\" />";
$HTML .= "</form>\n";

$HTML .= "</html>";

echo($HTML);

function clearFFT() {
   $datei = fopen("fft.txt","w");      # create file if there is no fft.txt

   fwrite($datei,"Date");
   fwrite($datei,"\n");
   fwrite($datei,0);
   fwrite($datei,"\n");

   for ($i=0; $i<1024; $i++) {         # fill with zeros
     fwrite($datei,0);
     fwrite($datei,"\n");
   }

   fclose($datei);
   echo "Neue Datei geschrieben";
}

?>
