DS1337 rtc;
  

//======================================================================
//   Read time from serial input
//======================================================================
void setClockAlarm() {
   String input="";  
   int hour, minute;
   int wakeupHour, wakeupMinute;
   int inputError = 0;

   Wire.begin();

   Serial.println("========================================");
   Serial.print("Current RTC time: ");
   Serial.println(rtc.getDate().getTimeString());
   Serial.println("Wakeup at: "+rtc.getAlarm().getTimeString());
   Serial.print("Sleep after: ");
   Serial.print(MINUTES_AWAKE);
   Serial.println(" Minutes"); 
   Serial.println("========================================");

   do {
     Serial.println(">>Set Time and Alarm:   hh:mm,hh:mm");
     inputError = 0;
     input = "";
     
     while (!Serial.available()) {}   // Wait for user input
     
     while (Serial.available()) {
       char c = Serial.read();
       if (c!='\r') {
         if (input.length()<20 && c!='\n') {
           input = input + c;
         }
       }
     } 

     hour = input.substring(0,2).toInt();
     minute = input.substring(3,5).toInt();
     wakeupHour = input.substring(6,8).toInt();
     wakeupMinute = input.substring(9,11).toInt();

     if (input.length()<10) inputError = 1;
     if ((hour<0)||(hour>24)) inputError = 1; 
     if ((minute<0)||(hour>24)) inputError = 1; 
     if ((wakeupHour<0)||(hour>24)) inputError = 1; 
     if ((wakeupMinute<0)||(hour>24)) inputError = 1; 

   } while (inputError);

   rtc.init();
   rtc.setTime(hour,minute,0);
   rtc.setAlarmMode(DS1337_ALARM_ON_SECOND_MINUTE_HOUR);
   rtc.setAlarm(wakeupHour, wakeupMinute, 0);

   Serial.println("+++++++++++++++++++++++++++++++++++++++++++++++");
   Serial.print("New RTC time: ");
   Serial.println(rtc.getDate().getTimeString());
   Serial.println("Wakeup at: "+rtc.getAlarm().getTimeString());
   Serial.print("Sleep after: ");
   Serial.print(MINUTES_AWAKE);
   Serial.println(" Minutes"); 
   Serial.println("+++++++++++++++++++++++++++++++++++++++++++++++");

   delay(5000);

   gotoSleep();
  
}


//======================================================================
//                    Check if its time to sleep 
//======================================================================
boolean isTimeToSleep(int minutesAwake) {

   if (millis() > minutesAwake*60*1000) return(true); else return(false);
    
}

//======================================================================
//            Turn the Alarm active
//======================================================================
void gotoSleep() {

  Serial.println("--- Go to Sleep ----");

  Wire.begin();
  rtc.enableAlarm();
  rtc.clearAlarm();
}
