#include "Adafruit_ZeroFFT.h"

const q15_t window_hanning_16[] = {
    0,     1416,  5420,  11320, 18096, 24575, 29638, 32408,
    32408, 29638, 24575, 18096, 11320, 5420,  1416,  0,
};

const q15_t window_hanning_32[] = {
    0,     335,   1327,  2936,  5095,  7717,  10693, 13902, 17213, 20490, 23598,
    26411, 28814, 30708, 32015, 32682, 32682, 32015, 30708, 28814, 26411, 23598,
    20490, 17213, 13902, 10693, 7717,  5095,  2936,  1327,  335,   0,
};

const q15_t window_hanning_64[] = {
    0,     81,    324,   727,   1286,  1995,  2846,  3833,  4943,  6168,  7494,
    8909,  10397, 11946, 13538, 15159, 16791, 18420, 20029, 21601, 23121, 24575,
    25947, 27224, 28393, 29443, 30363, 31144, 31778, 32260, 32584, 32746, 32746,
    32584, 32260, 31778, 31144, 30363, 29443, 28393, 27224, 25947, 24575, 23121,
    21601, 20029, 18420, 16791, 15159, 13538, 11946, 10397, 8909,  7494,  6168,
    4943,  3833,  2846,  1995,  1286,  727,   324,   81,    0,
};

const q15_t window_hanning_128[] = {
    0,     20,    80,    180,   319,   498,   716,   972,   1266,  1597,  1964,
    2366,  2803,  3273,  3775,  4308,  4870,  5461,  6078,  6720,  7386,  8075,
    8783,  9510,  10254, 11013, 11785, 12568, 13361, 14161, 14966, 15775, 16586,
    17396, 18203, 19006, 19803, 20591, 21369, 22134, 22886, 23622, 24340, 25038,
    25716, 26370, 27000, 27604, 28181, 28729, 29246, 29732, 30186, 30605, 30990,
    31339, 31652, 31927, 32164, 32362, 32521, 32641, 32721, 32761, 32761, 32721,
    32641, 32521, 32362, 32164, 31927, 31652, 31339, 30990, 30605, 30186, 29732,
    29246, 28729, 28181, 27604, 27000, 26370, 25716, 25038, 24340, 23622, 22886,
    22134, 21369, 20591, 19803, 19006, 18203, 17396, 16586, 15775, 14966, 14161,
    13361, 12568, 11785, 11013, 10254, 9510,  8783,  8075,  7386,  6720,  6078,
    5461,  4870,  4308,  3775,  3273,  2803,  2366,  1964,  1597,  1266,  972,
    716,   498,   319,   180,   80,    20,    0,
};

const q15_t window_hanning_256[] = {
    0,     4,     19,    44,    79,    124,   178,   243,   317,   401,   494,
    598,   710,   833,   965,   1106,  1256,  1416,  1585,  1762,  1949,  2144,
    2348,  2561,  2782,  3011,  3248,  3493,  3746,  4007,  4275,  4551,  4834,
    5124,  5420,  5724,  6033,  6349,  6672,  7000,  7333,  7673,  8017,  8367,
    8721,  9080,  9444,  9812,  10183, 10559, 10938, 11320, 11706, 12094, 12485,
    12878, 13273, 13671, 14070, 14470, 14871, 15274, 15677, 16080, 16484, 16888,
    17291, 17694, 18096, 18496, 18896, 19294, 19691, 20085, 20477, 20867, 21253,
    21637, 22018, 22395, 22769, 23139, 23505, 23866, 24223, 24575, 24922, 25264,
    25600, 25931, 26256, 26575, 26888, 27195, 27495, 27788, 28074, 28354, 28626,
    28890, 29147, 29396, 29638, 29871, 30096, 30313, 30521, 30720, 30911, 31094,
    31267, 31431, 31586, 31732, 31868, 31996, 32113, 32221, 32320, 32408, 32488,
    32557, 32616, 32666, 32706, 32735, 32755, 32765, 32765, 32755, 32735, 32706,
    32666, 32616, 32557, 32488, 32408, 32320, 32221, 32113, 31996, 31868, 31732,
    31586, 31431, 31267, 31094, 30911, 30720, 30521, 30313, 30096, 29871, 29638,
    29396, 29147, 28890, 28626, 28354, 28074, 27788, 27495, 27195, 26888, 26575,
    26256, 25931, 25600, 25264, 24922, 24575, 24223, 23866, 23505, 23139, 22769,
    22395, 22018, 21637, 21253, 20867, 20477, 20085, 19691, 19294, 18896, 18496,
    18096, 17694, 17291, 16888, 16484, 16080, 15677, 15274, 14871, 14470, 14070,
    13671, 13273, 12878, 12485, 12094, 11706, 11320, 10938, 10559, 10183, 9812,
    9444,  9080,  8721,  8367,  8017,  7673,  7333,  7000,  6672,  6349,  6033,
    5724,  5420,  5124,  4834,  4551,  4275,  4007,  3746,  3493,  3248,  3011,
    2782,  2561,  2348,  2144,  1949,  1762,  1585,  1416,  1256,  1106,  965,
    833,   710,   598,   494,   401,   317,   243,   178,   124,   79,    44,
    19,    4,     0,
};

const q15_t window_hanning_512[] = {
    0,     1,     4,     11,    19,    30,    44,    60,    79,    100,   123,
    149,   178,   208,   242,   277,   316,   356,   399,   445,   492,   543,
    595,   650,   708,   767,   830,   894,   961,   1030,  1102,  1175,  1251,
    1330,  1410,  1493,  1579,  1666,  1756,  1847,  1941,  2038,  2136,  2237,
    2339,  2444,  2551,  2660,  2771,  2884,  2999,  3117,  3236,  3357,  3480,
    3605,  3732,  3861,  3992,  4125,  4259,  4396,  4534,  4674,  4816,  4959,
    5105,  5252,  5400,  5551,  5703,  5856,  6011,  6168,  6326,  6486,  6647,
    6810,  6974,  7140,  7307,  7475,  7645,  7816,  7989,  8162,  8337,  8513,
    8690,  8869,  9048,  9229,  9411,  9594,  9778,  9962,  10148, 10335, 10523,
    10711, 10901, 11091, 11282, 11474, 11666, 11860, 12054, 12248, 12443, 12639,
    12836, 13033, 13230, 13428, 13626, 13825, 14024, 14224, 14424, 14624, 14824,
    15025, 15226, 15427, 15628, 15829, 16030, 16232, 16433, 16635, 16836, 17038,
    17239, 17440, 17641, 17842, 18042, 18242, 18442, 18642, 18841, 19040, 19239,
    19437, 19635, 19832, 20029, 20225, 20420, 20615, 20810, 21003, 21196, 21388,
    21580, 21770, 21960, 22149, 22337, 22525, 22711, 22896, 23080, 23264, 23446,
    23627, 23807, 23986, 24164, 24341, 24517, 24691, 24864, 25035, 25206, 25375,
    25543, 25709, 25874, 26037, 26199, 26360, 26519, 26677, 26832, 26987, 27140,
    27291, 27440, 27588, 27734, 27879, 28021, 28162, 28301, 28439, 28574, 28708,
    28839, 28969, 29097, 29223, 29348, 29470, 29590, 29708, 29824, 29939, 30051,
    30161, 30269, 30375, 30478, 30580, 30679, 30777, 30872, 30965, 31056, 31144,
    31230, 31314, 31396, 31476, 31553, 31628, 31700, 31771, 31839, 31904, 31968,
    32029, 32087, 32144, 32197, 32249, 32298, 32344, 32389, 32430, 32470, 32507,
    32541, 32573, 32603, 32630, 32655, 32677, 32697, 32714, 32729, 32741, 32751,
    32759, 32764, 32766, 32766, 32764, 32759, 32751, 32741, 32729, 32714, 32697,
    32677, 32655, 32630, 32603, 32573, 32541, 32507, 32470, 32430, 32389, 32344,
    32298, 32249, 32197, 32144, 32087, 32029, 31968, 31904, 31839, 31771, 31700,
    31628, 31553, 31476, 31396, 31314, 31230, 31144, 31056, 30965, 30872, 30777,
    30679, 30580, 30478, 30375, 30269, 30161, 30051, 29939, 29824, 29708, 29590,
    29470, 29348, 29223, 29097, 28969, 28839, 28708, 28574, 28439, 28301, 28162,
    28021, 27879, 27734, 27588, 27440, 27291, 27140, 26987, 26832, 26677, 26519,
    26360, 26199, 26037, 25874, 25709, 25543, 25375, 25206, 25035, 24864, 24691,
    24517, 24341, 24164, 23986, 23807, 23627, 23446, 23264, 23080, 22896, 22711,
    22525, 22337, 22149, 21960, 21770, 21580, 21388, 21196, 21003, 20810, 20615,
    20420, 20225, 20029, 19832, 19635, 19437, 19239, 19040, 18841, 18642, 18442,
    18242, 18042, 17842, 17641, 17440, 17239, 17038, 16836, 16635, 16433, 16232,
    16030, 15829, 15628, 15427, 15226, 15025, 14824, 14624, 14424, 14224, 14024,
    13825, 13626, 13428, 13230, 13033, 12836, 12639, 12443, 12248, 12054, 11860,
    11666, 11474, 11282, 11091, 10901, 10711, 10523, 10335, 10148, 9962,  9778,
    9594,  9411,  9229,  9048,  8869,  8690,  8513,  8337,  8162,  7989,  7816,
    7645,  7475,  7307,  7140,  6974,  6810,  6647,  6486,  6326,  6168,  6011,
    5856,  5703,  5551,  5400,  5252,  5105,  4959,  4816,  4674,  4534,  4396,
    4259,  4125,  3992,  3861,  3732,  3605,  3480,  3357,  3236,  3117,  2999,
    2884,  2771,  2660,  2551,  2444,  2339,  2237,  2136,  2038,  1941,  1847,
    1756,  1666,  1579,  1493,  1410,  1330,  1251,  1175,  1102,  1030,  961,
    894,   830,   767,   708,   650,   595,   543,   492,   445,   399,   356,
    316,   277,   242,   208,   178,   149,   123,   100,   79,    60,    44,
    30,    19,    11,    4,     1,     0,
};

const q15_t window_hanning_1024[] = {
    0,     0,     1,     2,     4,     7,     11,    15,    19,    25,    30,
    37,    44,    52,    60,    69,    79,    89,    100,   111,   123,   136,
    149,   163,   177,   192,   208,   224,   241,   259,   277,   296,   315,
    335,   355,   377,   398,   421,   444,   467,   491,   516,   542,   568,
    594,   621,   649,   677,   706,   736,   766,   797,   828,   860,   892,
    925,   959,   993,   1028,  1063,  1099,  1136,  1173,  1211,  1249,  1288,
    1327,  1367,  1408,  1449,  1491,  1533,  1576,  1619,  1663,  1707,  1752,
    1798,  1844,  1891,  1938,  1986,  2034,  2083,  2132,  2182,  2232,  2283,
    2335,  2387,  2439,  2493,  2546,  2600,  2655,  2710,  2766,  2822,  2879,
    2936,  2994,  3052,  3111,  3170,  3230,  3290,  3351,  3412,  3474,  3536,
    3599,  3662,  3725,  3789,  3854,  3919,  3985,  4051,  4117,  4184,  4252,
    4319,  4388,  4456,  4526,  4595,  4665,  4736,  4807,  4878,  4950,  5023,
    5095,  5168,  5242,  5316,  5390,  5465,  5540,  5616,  5692,  5769,  5845,
    5923,  6000,  6078,  6157,  6236,  6315,  6394,  6474,  6555,  6635,  6716,
    6798,  6880,  6962,  7044,  7127,  7210,  7294,  7378,  7462,  7547,  7631,
    7717,  7802,  7888,  7974,  8061,  8148,  8235,  8322,  8410,  8498,  8586,
    8675,  8764,  8853,  8943,  9033,  9123,  9213,  9304,  9395,  9486,  9577,
    9669,  9761,  9853,  9945,  10038, 10131, 10224, 10317, 10411, 10505, 10599,
    10693, 10787, 10882, 10977, 11072, 11167, 11263, 11359, 11454, 11550, 11647,
    11743, 11840, 11936, 12033, 12130, 12228, 12325, 12423, 12520, 12618, 12716,
    12814, 12913, 13011, 13110, 13208, 13307, 13406, 13505, 13604, 13703, 13803,
    13902, 14002, 14101, 14201, 14301, 14401, 14500, 14600, 14700, 14801, 14901,
    15001, 15101, 15202, 15302, 15402, 15503, 15603, 15704, 15805, 15905, 16006,
    16106, 16207, 16308, 16408, 16509, 16609, 16710, 16811, 16911, 17012, 17112,
    17213, 17313, 17414, 17514, 17615, 17715, 17815, 17915, 18015, 18116, 18216,
    18316, 18415, 18515, 18615, 18715, 18814, 18914, 19013, 19112, 19211, 19311,
    19409, 19508, 19607, 19706, 19804, 19902, 20001, 20099, 20197, 20294, 20392,
    20490, 20587, 20684, 20781, 20878, 20975, 21071, 21167, 21264, 21360, 21455,
    21551, 21646, 21742, 21837, 21931, 22026, 22120, 22214, 22308, 22402, 22495,
    22589, 22682, 22775, 22867, 22959, 23051, 23143, 23235, 23326, 23417, 23508,
    23598, 23688, 23778, 23868, 23957, 24046, 24135, 24224, 24312, 24400, 24487,
    24575, 24662, 24748, 24835, 24921, 25007, 25092, 25177, 25262, 25346, 25430,
    25514, 25597, 25680, 25763, 25845, 25927, 26009, 26090, 26171, 26252, 26332,
    26411, 26491, 26570, 26648, 26727, 26805, 26882, 26959, 27036, 27112, 27188,
    27263, 27338, 27413, 27487, 27561, 27634, 27707, 27780, 27852, 27923, 27995,
    28065, 28136, 28206, 28275, 28344, 28412, 28481, 28548, 28615, 28682, 28748,
    28814, 28879, 28944, 29009, 29073, 29136, 29199, 29261, 29323, 29385, 29446,
    29506, 29566, 29626, 29685, 29743, 29801, 29859, 29916, 29972, 30028, 30083,
    30138, 30193, 30247, 30300, 30353, 30405, 30457, 30508, 30559, 30609, 30659,
    30708, 30756, 30804, 30852, 30899, 30945, 30991, 31036, 31081, 31125, 31169,
    31212, 31254, 31296, 31338, 31379, 31419, 31459, 31498, 31536, 31574, 31612,
    31648, 31685, 31720, 31755, 31790, 31824, 31857, 31890, 31922, 31954, 31985,
    32015, 32045, 32074, 32103, 32131, 32158, 32185, 32211, 32237, 32262, 32287,
    32311, 32334, 32357, 32379, 32400, 32421, 32441, 32461, 32480, 32498, 32516,
    32533, 32550, 32566, 32581, 32596, 32610, 32624, 32637, 32649, 32661, 32672,
    32682, 32692, 32702, 32710, 32718, 32726, 32732, 32739, 32744, 32749, 32753,
    32757, 32760, 32763, 32765, 32766, 32766, 32766, 32766, 32765, 32763, 32760,
    32757, 32753, 32749, 32744, 32739, 32732, 32726, 32718, 32710, 32702, 32692,
    32682, 32672, 32661, 32649, 32637, 32624, 32610, 32596, 32581, 32566, 32550,
    32533, 32516, 32498, 32480, 32461, 32441, 32421, 32400, 32379, 32357, 32334,
    32311, 32287, 32262, 32237, 32211, 32185, 32158, 32131, 32103, 32074, 32045,
    32015, 31985, 31954, 31922, 31890, 31857, 31824, 31790, 31755, 31720, 31685,
    31648, 31612, 31574, 31536, 31498, 31459, 31419, 31379, 31338, 31296, 31254,
    31212, 31169, 31125, 31081, 31036, 30991, 30945, 30899, 30852, 30804, 30756,
    30708, 30659, 30609, 30559, 30508, 30457, 30405, 30353, 30300, 30247, 30193,
    30138, 30083, 30028, 29972, 29916, 29859, 29801, 29743, 29685, 29626, 29566,
    29506, 29446, 29385, 29323, 29261, 29199, 29136, 29073, 29009, 28944, 28879,
    28814, 28748, 28682, 28615, 28548, 28481, 28412, 28344, 28275, 28206, 28136,
    28065, 27995, 27923, 27852, 27780, 27707, 27634, 27561, 27487, 27413, 27338,
    27263, 27188, 27112, 27036, 26959, 26882, 26805, 26727, 26648, 26570, 26491,
    26411, 26332, 26252, 26171, 26090, 26009, 25927, 25845, 25763, 25680, 25597,
    25514, 25430, 25346, 25262, 25177, 25092, 25007, 24921, 24835, 24748, 24662,
    24575, 24487, 24400, 24312, 24224, 24135, 24046, 23957, 23868, 23778, 23688,
    23598, 23508, 23417, 23326, 23235, 23143, 23051, 22959, 22867, 22775, 22682,
    22589, 22495, 22402, 22308, 22214, 22120, 22026, 21931, 21837, 21742, 21646,
    21551, 21455, 21360, 21264, 21167, 21071, 20975, 20878, 20781, 20684, 20587,
    20490, 20392, 20294, 20197, 20099, 20001, 19902, 19804, 19706, 19607, 19508,
    19409, 19311, 19211, 19112, 19013, 18914, 18814, 18715, 18615, 18515, 18415,
    18316, 18216, 18116, 18015, 17915, 17815, 17715, 17615, 17514, 17414, 17313,
    17213, 17112, 17012, 16911, 16811, 16710, 16609, 16509, 16408, 16308, 16207,
    16106, 16006, 15905, 15805, 15704, 15603, 15503, 15402, 15302, 15202, 15101,
    15001, 14901, 14801, 14700, 14600, 14500, 14401, 14301, 14201, 14101, 14002,
    13902, 13803, 13703, 13604, 13505, 13406, 13307, 13208, 13110, 13011, 12913,
    12814, 12716, 12618, 12520, 12423, 12325, 12228, 12130, 12033, 11936, 11840,
    11743, 11647, 11550, 11454, 11359, 11263, 11167, 11072, 10977, 10882, 10787,
    10693, 10599, 10505, 10411, 10317, 10224, 10131, 10038, 9945,  9853,  9761,
    9669,  9577,  9486,  9395,  9304,  9213,  9123,  9033,  8943,  8853,  8764,
    8675,  8586,  8498,  8410,  8322,  8235,  8148,  8061,  7974,  7888,  7802,
    7717,  7631,  7547,  7462,  7378,  7294,  7210,  7127,  7044,  6962,  6880,
    6798,  6716,  6635,  6555,  6474,  6394,  6315,  6236,  6157,  6078,  6000,
    5923,  5845,  5769,  5692,  5616,  5540,  5465,  5390,  5316,  5242,  5168,
    5095,  5023,  4950,  4878,  4807,  4736,  4665,  4595,  4526,  4456,  4388,
    4319,  4252,  4184,  4117,  4051,  3985,  3919,  3854,  3789,  3725,  3662,
    3599,  3536,  3474,  3412,  3351,  3290,  3230,  3170,  3111,  3052,  2994,
    2936,  2879,  2822,  2766,  2710,  2655,  2600,  2546,  2493,  2439,  2387,
    2335,  2283,  2232,  2182,  2132,  2083,  2034,  1986,  1938,  1891,  1844,
    1798,  1752,  1707,  1663,  1619,  1576,  1533,  1491,  1449,  1408,  1367,
    1327,  1288,  1249,  1211,  1173,  1136,  1099,  1063,  1028,  993,   959,
    925,   892,   860,   828,   797,   766,   736,   706,   677,   649,   621,
    594,   568,   542,   516,   491,   467,   444,   421,   398,   377,   355,
    335,   315,   296,   277,   259,   241,   224,   208,   192,   177,   163,
    149,   136,   123,   111,   100,   89,    79,    69,    60,    52,    44,
    37,    30,    25,    19,    15,    11,    7,     4,     2,     1,     0,
    0,
};

const q15_t window_hanning_2048[] = {
    0,     0,     0,     0,     1,     1,     2,     3,     4,     6,     7,
    9,     11,    13,    15,    17,    19,    22,    24,    27,    30,    34,
    37,    40,    44,    48,    52,    56,    60,    64,    69,    74,    78,
    83,    89,    94,    99,    105,   111,   117,   123,   129,   135,   142,
    149,   156,   163,   170,   177,   184,   192,   200,   208,   216,   224,
    232,   241,   250,   258,   267,   277,   286,   295,   305,   315,   325,
    335,   345,   355,   366,   376,   387,   398,   409,   420,   432,   443,
    455,   467,   479,   491,   503,   516,   528,   541,   554,   567,   580,
    594,   607,   621,   634,   648,   663,   677,   691,   706,   720,   735,
    750,   765,   781,   796,   811,   827,   843,   859,   875,   892,   908,
    925,   941,   958,   975,   992,   1010,  1027,  1045,  1062,  1080,  1098,
    1117,  1135,  1153,  1172,  1191,  1210,  1229,  1248,  1267,  1287,  1306,
    1326,  1346,  1366,  1386,  1406,  1427,  1447,  1468,  1489,  1510,  1531,
    1553,  1574,  1596,  1617,  1639,  1661,  1683,  1706,  1728,  1751,  1773,
    1796,  1819,  1842,  1865,  1889,  1912,  1936,  1960,  1984,  2008,  2032,
    2056,  2081,  2105,  2130,  2155,  2180,  2205,  2230,  2256,  2281,  2307,
    2333,  2359,  2385,  2411,  2437,  2464,  2490,  2517,  2544,  2571,  2598,
    2625,  2652,  2680,  2708,  2735,  2763,  2791,  2819,  2848,  2876,  2905,
    2933,  2962,  2991,  3020,  3049,  3078,  3108,  3137,  3167,  3197,  3227,
    3257,  3287,  3317,  3348,  3378,  3409,  3439,  3470,  3501,  3533,  3564,
    3595,  3627,  3658,  3690,  3722,  3754,  3786,  3818,  3850,  3883,  3916,
    3948,  3981,  4014,  4047,  4080,  4113,  4147,  4180,  4214,  4248,  4281,
    4315,  4349,  4384,  4418,  4452,  4487,  4521,  4556,  4591,  4626,  4661,
    4696,  4732,  4767,  4803,  4838,  4874,  4910,  4946,  4982,  5018,  5054,
    5091,  5127,  5164,  5200,  5237,  5274,  5311,  5348,  5385,  5423,  5460,
    5498,  5535,  5573,  5611,  5649,  5687,  5725,  5763,  5802,  5840,  5879,
    5917,  5956,  5995,  6034,  6073,  6112,  6151,  6191,  6230,  6269,  6309,
    6349,  6389,  6428,  6468,  6509,  6549,  6589,  6629,  6670,  6710,  6751,
    6792,  6833,  6873,  6914,  6956,  6997,  7038,  7079,  7121,  7162,  7204,
    7246,  7287,  7329,  7371,  7413,  7455,  7498,  7540,  7582,  7625,  7667,
    7710,  7753,  7795,  7838,  7881,  7924,  7967,  8010,  8054,  8097,  8140,
    8184,  8228,  8271,  8315,  8359,  8403,  8447,  8491,  8535,  8579,  8623,
    8667,  8712,  8756,  8801,  8846,  8890,  8935,  8980,  9025,  9070,  9115,
    9160,  9205,  9250,  9296,  9341,  9386,  9432,  9477,  9523,  9569,  9614,
    9660,  9706,  9752,  9798,  9844,  9890,  9937,  9983,  10029, 10076, 10122,
    10169, 10215, 10262, 10308, 10355, 10402, 10449, 10496, 10543, 10590, 10637,
    10684, 10731, 10778, 10825, 10873, 10920, 10968, 11015, 11063, 11110, 11158,
    11206, 11253, 11301, 11349, 11397, 11445, 11493, 11541, 11589, 11637, 11685,
    11733, 11781, 11830, 11878, 11926, 11975, 12023, 12072, 12120, 12169, 12218,
    12266, 12315, 12364, 12412, 12461, 12510, 12559, 12608, 12657, 12706, 12755,
    12804, 12853, 12902, 12951, 13000, 13050, 13099, 13148, 13198, 13247, 13296,
    13346, 13395, 13445, 13494, 13544, 13593, 13643, 13692, 13742, 13792, 13841,
    13891, 13941, 13990, 14040, 14090, 14140, 14189, 14239, 14289, 14339, 14389,
    14439, 14489, 14539, 14589, 14639, 14689, 14739, 14789, 14839, 14889, 14939,
    14989, 15039, 15089, 15140, 15190, 15240, 15290, 15340, 15390, 15441, 15491,
    15541, 15591, 15641, 15692, 15742, 15792, 15842, 15893, 15943, 15993, 16044,
    16094, 16144, 16194, 16245, 16295, 16345, 16396, 16446, 16496, 16546, 16597,
    16647, 16697, 16748, 16798, 16848, 16898, 16949, 16999, 17049, 17099, 17150,
    17200, 17250, 17300, 17350, 17401, 17451, 17501, 17551, 17601, 17652, 17702,
    17752, 17802, 17852, 17902, 17952, 18002, 18052, 18102, 18152, 18202, 18252,
    18302, 18352, 18402, 18452, 18502, 18552, 18601, 18651, 18701, 18751, 18801,
    18850, 18900, 18950, 18999, 19049, 19099, 19148, 19198, 19247, 19297, 19346,
    19396, 19445, 19494, 19544, 19593, 19642, 19692, 19741, 19790, 19839, 19888,
    19938, 19987, 20036, 20085, 20134, 20183, 20231, 20280, 20329, 20378, 20427,
    20475, 20524, 20573, 20621, 20670, 20718, 20767, 20815, 20864, 20912, 20960,
    21009, 21057, 21105, 21153, 21201, 21249, 21297, 21345, 21393, 21441, 21489,
    21537, 21584, 21632, 21680, 21727, 21775, 21822, 21870, 21917, 21964, 22011,
    22059, 22106, 22153, 22200, 22247, 22294, 22341, 22388, 22434, 22481, 22528,
    22574, 22621, 22667, 22714, 22760, 22806, 22852, 22899, 22945, 22991, 23037,
    23083, 23129, 23174, 23220, 23266, 23311, 23357, 23402, 23448, 23493, 23538,
    23584, 23629, 23674, 23719, 23764, 23809, 23853, 23898, 23943, 23987, 24032,
    24076, 24121, 24165, 24209, 24253, 24297, 24341, 24385, 24429, 24473, 24517,
    24560, 24604, 24647, 24691, 24734, 24777, 24820, 24863, 24906, 24949, 24992,
    25035, 25077, 25120, 25163, 25205, 25247, 25290, 25332, 25374, 25416, 25458,
    25500, 25541, 25583, 25625, 25666, 25707, 25749, 25790, 25831, 25872, 25913,
    25954, 25995, 26035, 26076, 26116, 26157, 26197, 26237, 26277, 26318, 26357,
    26397, 26437, 26477, 26516, 26556, 26595, 26634, 26674, 26713, 26752, 26791,
    26829, 26868, 26907, 26945, 26984, 27022, 27060, 27098, 27136, 27174, 27212,
    27249, 27287, 27325, 27362, 27399, 27436, 27473, 27510, 27547, 27584, 27621,
    27657, 27694, 27730, 27766, 27802, 27838, 27874, 27910, 27946, 27981, 28017,
    28052, 28087, 28122, 28157, 28192, 28227, 28262, 28296, 28331, 28365, 28399,
    28434, 28468, 28502, 28535, 28569, 28603, 28636, 28669, 28702, 28736, 28769,
    28801, 28834, 28867, 28899, 28932, 28964, 28996, 29028, 29060, 29092, 29124,
    29155, 29187, 29218, 29249, 29280, 29311, 29342, 29373, 29403, 29434, 29464,
    29494, 29524, 29554, 29584, 29614, 29643, 29673, 29702, 29731, 29761, 29790,
    29818, 29847, 29876, 29904, 29932, 29961, 29989, 30017, 30045, 30072, 30100,
    30127, 30155, 30182, 30209, 30236, 30262, 30289, 30316, 30342, 30368, 30394,
    30420, 30446, 30472, 30498, 30523, 30548, 30574, 30599, 30624, 30648, 30673,
    30698, 30722, 30746, 30770, 30794, 30818, 30842, 30866, 30889, 30912, 30935,
    30958, 30981, 31004, 31027, 31049, 31072, 31094, 31116, 31138, 31160, 31181,
    31203, 31224, 31245, 31266, 31287, 31308, 31329, 31349, 31370, 31390, 31410,
    31430, 31450, 31470, 31489, 31509, 31528, 31547, 31566, 31585, 31603, 31622,
    31640, 31659, 31677, 31695, 31712, 31730, 31748, 31765, 31782, 31799, 31816,
    31833, 31850, 31866, 31883, 31899, 31915, 31931, 31947, 31962, 31978, 31993,
    32008, 32023, 32038, 32053, 32068, 32082, 32096, 32111, 32125, 32138, 32152,
    32166, 32179, 32192, 32206, 32219, 32231, 32244, 32257, 32269, 32281, 32293,
    32305, 32317, 32329, 32340, 32351, 32362, 32374, 32384, 32395, 32406, 32416,
    32426, 32436, 32446, 32456, 32466, 32475, 32485, 32494, 32503, 32512, 32521,
    32529, 32538, 32546, 32554, 32562, 32570, 32578, 32585, 32593, 32600, 32607,
    32614, 32621, 32627, 32634, 32640, 32646, 32652, 32658, 32664, 32669, 32675,
    32680, 32685, 32690, 32695, 32699, 32704, 32708, 32712, 32716, 32720, 32724,
    32727, 32731, 32734, 32737, 32740, 32743, 32745, 32748, 32750, 32752, 32754,
    32756, 32758, 32760, 32761, 32762, 32763, 32764, 32765, 32766, 32766, 32766,
    32766, 32766, 32766, 32766, 32766, 32765, 32764, 32763, 32762, 32761, 32760,
    32758, 32756, 32754, 32752, 32750, 32748, 32745, 32743, 32740, 32737, 32734,
    32731, 32727, 32724, 32720, 32716, 32712, 32708, 32704, 32699, 32695, 32690,
    32685, 32680, 32675, 32669, 32664, 32658, 32652, 32646, 32640, 32634, 32627,
    32621, 32614, 32607, 32600, 32593, 32585, 32578, 32570, 32562, 32554, 32546,
    32538, 32529, 32521, 32512, 32503, 32494, 32485, 32475, 32466, 32456, 32446,
    32436, 32426, 32416, 32406, 32395, 32384, 32374, 32362, 32351, 32340, 32329,
    32317, 32305, 32293, 32281, 32269, 32257, 32244, 32231, 32219, 32206, 32192,
    32179, 32166, 32152, 32138, 32125, 32111, 32096, 32082, 32068, 32053, 32038,
    32023, 32008, 31993, 31978, 31962, 31947, 31931, 31915, 31899, 31883, 31866,
    31850, 31833, 31816, 31799, 31782, 31765, 31748, 31730, 31712, 31695, 31677,
    31659, 31640, 31622, 31603, 31585, 31566, 31547, 31528, 31509, 31489, 31470,
    31450, 31430, 31410, 31390, 31370, 31349, 31329, 31308, 31287, 31266, 31245,
    31224, 31203, 31181, 31160, 31138, 31116, 31094, 31072, 31049, 31027, 31004,
    30981, 30958, 30935, 30912, 30889, 30866, 30842, 30818, 30794, 30770, 30746,
    30722, 30698, 30673, 30648, 30624, 30599, 30574, 30548, 30523, 30498, 30472,
    30446, 30420, 30394, 30368, 30342, 30316, 30289, 30262, 30236, 30209, 30182,
    30155, 30127, 30100, 30072, 30045, 30017, 29989, 29961, 29932, 29904, 29876,
    29847, 29818, 29790, 29761, 29731, 29702, 29673, 29643, 29614, 29584, 29554,
    29524, 29494, 29464, 29434, 29403, 29373, 29342, 29311, 29280, 29249, 29218,
    29187, 29155, 29124, 29092, 29060, 29028, 28996, 28964, 28932, 28899, 28867,
    28834, 28801, 28769, 28736, 28702, 28669, 28636, 28603, 28569, 28535, 28502,
    28468, 28434, 28399, 28365, 28331, 28296, 28262, 28227, 28192, 28157, 28122,
    28087, 28052, 28017, 27981, 27946, 27910, 27874, 27838, 27802, 27766, 27730,
    27694, 27657, 27621, 27584, 27547, 27510, 27473, 27436, 27399, 27362, 27325,
    27287, 27249, 27212, 27174, 27136, 27098, 27060, 27022, 26984, 26945, 26907,
    26868, 26829, 26791, 26752, 26713, 26674, 26634, 26595, 26556, 26516, 26477,
    26437, 26397, 26357, 26318, 26277, 26237, 26197, 26157, 26116, 26076, 26035,
    25995, 25954, 25913, 25872, 25831, 25790, 25749, 25707, 25666, 25625, 25583,
    25541, 25500, 25458, 25416, 25374, 25332, 25290, 25247, 25205, 25163, 25120,
    25077, 25035, 24992, 24949, 24906, 24863, 24820, 24777, 24734, 24691, 24647,
    24604, 24560, 24517, 24473, 24429, 24385, 24341, 24297, 24253, 24209, 24165,
    24121, 24076, 24032, 23987, 23943, 23898, 23853, 23809, 23764, 23719, 23674,
    23629, 23584, 23538, 23493, 23448, 23402, 23357, 23311, 23266, 23220, 23174,
    23129, 23083, 23037, 22991, 22945, 22899, 22852, 22806, 22760, 22714, 22667,
    22621, 22574, 22528, 22481, 22434, 22388, 22341, 22294, 22247, 22200, 22153,
    22106, 22059, 22011, 21964, 21917, 21870, 21822, 21775, 21727, 21680, 21632,
    21584, 21537, 21489, 21441, 21393, 21345, 21297, 21249, 21201, 21153, 21105,
    21057, 21009, 20960, 20912, 20864, 20815, 20767, 20718, 20670, 20621, 20573,
    20524, 20475, 20427, 20378, 20329, 20280, 20231, 20183, 20134, 20085, 20036,
    19987, 19938, 19888, 19839, 19790, 19741, 19692, 19642, 19593, 19544, 19494,
    19445, 19396, 19346, 19297, 19247, 19198, 19148, 19099, 19049, 18999, 18950,
    18900, 18850, 18801, 18751, 18701, 18651, 18601, 18552, 18502, 18452, 18402,
    18352, 18302, 18252, 18202, 18152, 18102, 18052, 18002, 17952, 17902, 17852,
    17802, 17752, 17702, 17652, 17601, 17551, 17501, 17451, 17401, 17350, 17300,
    17250, 17200, 17150, 17099, 17049, 16999, 16949, 16898, 16848, 16798, 16748,
    16697, 16647, 16597, 16546, 16496, 16446, 16396, 16345, 16295, 16245, 16194,
    16144, 16094, 16044, 15993, 15943, 15893, 15842, 15792, 15742, 15692, 15641,
    15591, 15541, 15491, 15441, 15390, 15340, 15290, 15240, 15190, 15140, 15089,
    15039, 14989, 14939, 14889, 14839, 14789, 14739, 14689, 14639, 14589, 14539,
    14489, 14439, 14389, 14339, 14289, 14239, 14189, 14140, 14090, 14040, 13990,
    13941, 13891, 13841, 13792, 13742, 13692, 13643, 13593, 13544, 13494, 13445,
    13395, 13346, 13296, 13247, 13198, 13148, 13099, 13050, 13000, 12951, 12902,
    12853, 12804, 12755, 12706, 12657, 12608, 12559, 12510, 12461, 12412, 12364,
    12315, 12266, 12218, 12169, 12120, 12072, 12023, 11975, 11926, 11878, 11830,
    11781, 11733, 11685, 11637, 11589, 11541, 11493, 11445, 11397, 11349, 11301,
    11253, 11206, 11158, 11110, 11063, 11015, 10968, 10920, 10873, 10825, 10778,
    10731, 10684, 10637, 10590, 10543, 10496, 10449, 10402, 10355, 10308, 10262,
    10215, 10169, 10122, 10076, 10029, 9983,  9937,  9890,  9844,  9798,  9752,
    9706,  9660,  9614,  9569,  9523,  9477,  9432,  9386,  9341,  9296,  9250,
    9205,  9160,  9115,  9070,  9025,  8980,  8935,  8890,  8846,  8801,  8756,
    8712,  8667,  8623,  8579,  8535,  8491,  8447,  8403,  8359,  8315,  8271,
    8228,  8184,  8140,  8097,  8054,  8010,  7967,  7924,  7881,  7838,  7795,
    7753,  7710,  7667,  7625,  7582,  7540,  7498,  7455,  7413,  7371,  7329,
    7287,  7246,  7204,  7162,  7121,  7079,  7038,  6997,  6956,  6914,  6873,
    6833,  6792,  6751,  6710,  6670,  6629,  6589,  6549,  6509,  6468,  6428,
    6389,  6349,  6309,  6269,  6230,  6191,  6151,  6112,  6073,  6034,  5995,
    5956,  5917,  5879,  5840,  5802,  5763,  5725,  5687,  5649,  5611,  5573,
    5535,  5498,  5460,  5423,  5385,  5348,  5311,  5274,  5237,  5200,  5164,
    5127,  5091,  5054,  5018,  4982,  4946,  4910,  4874,  4838,  4803,  4767,
    4732,  4696,  4661,  4626,  4591,  4556,  4521,  4487,  4452,  4418,  4384,
    4349,  4315,  4281,  4248,  4214,  4180,  4147,  4113,  4080,  4047,  4014,
    3981,  3948,  3916,  3883,  3850,  3818,  3786,  3754,  3722,  3690,  3658,
    3627,  3595,  3564,  3533,  3501,  3470,  3439,  3409,  3378,  3348,  3317,
    3287,  3257,  3227,  3197,  3167,  3137,  3108,  3078,  3049,  3020,  2991,
    2962,  2933,  2905,  2876,  2848,  2819,  2791,  2763,  2735,  2708,  2680,
    2652,  2625,  2598,  2571,  2544,  2517,  2490,  2464,  2437,  2411,  2385,
    2359,  2333,  2307,  2281,  2256,  2230,  2205,  2180,  2155,  2130,  2105,
    2081,  2056,  2032,  2008,  1984,  1960,  1936,  1912,  1889,  1865,  1842,
    1819,  1796,  1773,  1751,  1728,  1706,  1683,  1661,  1639,  1617,  1596,
    1574,  1553,  1531,  1510,  1489,  1468,  1447,  1427,  1406,  1386,  1366,
    1346,  1326,  1306,  1287,  1267,  1248,  1229,  1210,  1191,  1172,  1153,
    1135,  1117,  1098,  1080,  1062,  1045,  1027,  1010,  992,   975,   958,
    941,   925,   908,   892,   875,   859,   843,   827,   811,   796,   781,
    765,   750,   735,   720,   706,   691,   677,   663,   648,   634,   621,
    607,   594,   580,   567,   554,   541,   528,   516,   503,   491,   479,
    467,   455,   443,   432,   420,   409,   398,   387,   376,   366,   355,
    345,   335,   325,   315,   305,   295,   286,   277,   267,   258,   250,
    241,   232,   224,   216,   208,   200,   192,   184,   177,   170,   163,
    156,   149,   142,   135,   129,   123,   117,   111,   105,   99,    94,
    89,    83,    78,    74,    69,    64,    60,    56,    52,    48,    44,
    40,    37,    34,    30,    27,    24,    22,    19,    17,    15,    13,
    11,    9,     7,     6,     4,     3,     2,     1,     1,     0,     0,
    0,     0,
};

const q15_t window_hanning_4096[] = {
    0,     0,     0,     0,     0,     0,     0,     0,     1,     1,     1,
    2,     2,     3,     3,     4,     4,     5,     6,     6,     7,     8,
    9,     10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
    20,    22,    23,    24,    26,    27,    29,    30,    32,    34,    35,
    37,    39,    40,    42,    44,    46,    48,    50,    52,    54,    56,
    58,    60,    62,    64,    67,    69,    71,    74,    76,    78,    81,
    83,    86,    89,    91,    94,    97,    99,    102,   105,   108,   111,
    114,   117,   120,   123,   126,   129,   132,   135,   139,   142,   145,
    149,   152,   155,   159,   162,   166,   170,   173,   177,   181,   184,
    188,   192,   196,   200,   204,   208,   212,   216,   220,   224,   228,
    232,   237,   241,   245,   249,   254,   258,   263,   267,   272,   276,
    281,   286,   290,   295,   300,   305,   310,   314,   319,   324,   329,
    334,   339,   345,   350,   355,   360,   365,   371,   376,   381,   387,
    392,   398,   403,   409,   414,   420,   426,   432,   437,   443,   449,
    455,   461,   467,   473,   479,   485,   491,   497,   503,   509,   515,
    522,   528,   534,   541,   547,   554,   560,   567,   573,   580,   587,
    593,   600,   607,   614,   620,   627,   634,   641,   648,   655,   662,
    669,   676,   684,   691,   698,   705,   713,   720,   727,   735,   742,
    750,   757,   765,   772,   780,   788,   796,   803,   811,   819,   827,
    835,   843,   851,   859,   867,   875,   883,   891,   899,   908,   916,
    924,   932,   941,   949,   958,   966,   975,   983,   992,   1000,  1009,
    1018,  1027,  1035,  1044,  1053,  1062,  1071,  1080,  1089,  1098,  1107,
    1116,  1125,  1134,  1144,  1153,  1162,  1171,  1181,  1190,  1200,  1209,
    1219,  1228,  1238,  1247,  1257,  1267,  1276,  1286,  1296,  1306,  1315,
    1325,  1335,  1345,  1355,  1365,  1375,  1385,  1396,  1406,  1416,  1426,
    1436,  1447,  1457,  1467,  1478,  1488,  1499,  1509,  1520,  1531,  1541,
    1552,  1563,  1573,  1584,  1595,  1606,  1617,  1627,  1638,  1649,  1660,
    1671,  1682,  1694,  1705,  1716,  1727,  1738,  1750,  1761,  1772,  1784,
    1795,  1807,  1818,  1830,  1841,  1853,  1864,  1876,  1888,  1900,  1911,
    1923,  1935,  1947,  1959,  1971,  1983,  1995,  2007,  2019,  2031,  2043,
    2055,  2067,  2080,  2092,  2104,  2117,  2129,  2141,  2154,  2166,  2179,
    2191,  2204,  2217,  2229,  2242,  2255,  2267,  2280,  2293,  2306,  2319,
    2332,  2344,  2357,  2370,  2383,  2397,  2410,  2423,  2436,  2449,  2462,
    2476,  2489,  2502,  2516,  2529,  2543,  2556,  2570,  2583,  2597,  2610,
    2624,  2638,  2651,  2665,  2679,  2692,  2706,  2720,  2734,  2748,  2762,
    2776,  2790,  2804,  2818,  2832,  2846,  2860,  2875,  2889,  2903,  2918,
    2932,  2946,  2961,  2975,  2990,  3004,  3019,  3033,  3048,  3062,  3077,
    3092,  3106,  3121,  3136,  3151,  3166,  3180,  3195,  3210,  3225,  3240,
    3255,  3270,  3285,  3300,  3316,  3331,  3346,  3361,  3376,  3392,  3407,
    3422,  3438,  3453,  3469,  3484,  3500,  3515,  3531,  3546,  3562,  3578,
    3593,  3609,  3625,  3641,  3657,  3672,  3688,  3704,  3720,  3736,  3752,
    3768,  3784,  3800,  3816,  3833,  3849,  3865,  3881,  3897,  3914,  3930,
    3946,  3963,  3979,  3996,  4012,  4029,  4045,  4062,  4078,  4095,  4111,
    4128,  4145,  4162,  4178,  4195,  4212,  4229,  4246,  4263,  4279,  4296,
    4313,  4330,  4347,  4364,  4382,  4399,  4416,  4433,  4450,  4468,  4485,
    4502,  4519,  4537,  4554,  4572,  4589,  4606,  4624,  4641,  4659,  4677,
    4694,  4712,  4729,  4747,  4765,  4783,  4800,  4818,  4836,  4854,  4872,
    4890,  4907,  4925,  4943,  4961,  4979,  4998,  5016,  5034,  5052,  5070,
    5088,  5106,  5125,  5143,  5161,  5180,  5198,  5216,  5235,  5253,  5272,
    5290,  5309,  5327,  5346,  5364,  5383,  5402,  5420,  5439,  5458,  5476,
    5495,  5514,  5533,  5552,  5571,  5589,  5608,  5627,  5646,  5665,  5684,
    5703,  5722,  5742,  5761,  5780,  5799,  5818,  5837,  5857,  5876,  5895,
    5915,  5934,  5953,  5973,  5992,  6012,  6031,  6051,  6070,  6090,  6109,
    6129,  6148,  6168,  6188,  6207,  6227,  6247,  6267,  6286,  6306,  6326,
    6346,  6366,  6386,  6406,  6426,  6446,  6466,  6486,  6506,  6526,  6546,
    6566,  6586,  6606,  6626,  6647,  6667,  6687,  6707,  6728,  6748,  6768,
    6789,  6809,  6829,  6850,  6870,  6891,  6911,  6932,  6952,  6973,  6994,
    7014,  7035,  7055,  7076,  7097,  7118,  7138,  7159,  7180,  7201,  7221,
    7242,  7263,  7284,  7305,  7326,  7347,  7368,  7389,  7410,  7431,  7452,
    7473,  7494,  7515,  7536,  7558,  7579,  7600,  7621,  7643,  7664,  7685,
    7706,  7728,  7749,  7770,  7792,  7813,  7835,  7856,  7878,  7899,  7921,
    7942,  7964,  7985,  8007,  8029,  8050,  8072,  8093,  8115,  8137,  8159,
    8180,  8202,  8224,  8246,  8268,  8289,  8311,  8333,  8355,  8377,  8399,
    8421,  8443,  8465,  8487,  8509,  8531,  8553,  8575,  8597,  8619,  8642,
    8664,  8686,  8708,  8730,  8753,  8775,  8797,  8819,  8842,  8864,  8886,
    8909,  8931,  8953,  8976,  8998,  9021,  9043,  9066,  9088,  9111,  9133,
    9156,  9178,  9201,  9224,  9246,  9269,  9291,  9314,  9337,  9360,  9382,
    9405,  9428,  9450,  9473,  9496,  9519,  9542,  9565,  9587,  9610,  9633,
    9656,  9679,  9702,  9725,  9748,  9771,  9794,  9817,  9840,  9863,  9886,
    9909,  9932,  9955,  9979,  10002, 10025, 10048, 10071, 10094, 10118, 10141,
    10164, 10187, 10211, 10234, 10257, 10281, 10304, 10327, 10351, 10374, 10397,
    10421, 10444, 10468, 10491, 10515, 10538, 10562, 10585, 10609, 10632, 10656,
    10679, 10703, 10726, 10750, 10774, 10797, 10821, 10845, 10868, 10892, 10916,
    10939, 10963, 10987, 11010, 11034, 11058, 11082, 11106, 11129, 11153, 11177,
    11201, 11225, 11249, 11272, 11296, 11320, 11344, 11368, 11392, 11416, 11440,
    11464, 11488, 11512, 11536, 11560, 11584, 11608, 11632, 11656, 11680, 11704,
    11728, 11752, 11777, 11801, 11825, 11849, 11873, 11897, 11921, 11946, 11970,
    11994, 12018, 12043, 12067, 12091, 12115, 12140, 12164, 12188, 12212, 12237,
    12261, 12285, 12310, 12334, 12359, 12383, 12407, 12432, 12456, 12480, 12505,
    12529, 12554, 12578, 12603, 12627, 12652, 12676, 12701, 12725, 12750, 12774,
    12799, 12823, 12848, 12872, 12897, 12921, 12946, 12971, 12995, 13020, 13044,
    13069, 13094, 13118, 13143, 13167, 13192, 13217, 13241, 13266, 13291, 13316,
    13340, 13365, 13390, 13414, 13439, 13464, 13489, 13513, 13538, 13563, 13588,
    13612, 13637, 13662, 13687, 13711, 13736, 13761, 13786, 13811, 13836, 13860,
    13885, 13910, 13935, 13960, 13985, 14010, 14034, 14059, 14084, 14109, 14134,
    14159, 14184, 14209, 14234, 14259, 14283, 14308, 14333, 14358, 14383, 14408,
    14433, 14458, 14483, 14508, 14533, 14558, 14583, 14608, 14633, 14658, 14683,
    14708, 14733, 14758, 14783, 14808, 14833, 14858, 14883, 14908, 14933, 14958,
    14983, 15008, 15033, 15058, 15083, 15109, 15134, 15159, 15184, 15209, 15234,
    15259, 15284, 15309, 15334, 15359, 15384, 15409, 15435, 15460, 15485, 15510,
    15535, 15560, 15585, 15610, 15635, 15661, 15686, 15711, 15736, 15761, 15786,
    15811, 15836, 15861, 15887, 15912, 15937, 15962, 15987, 16012, 16037, 16063,
    16088, 16113, 16138, 16163, 16188, 16213, 16238, 16264, 16289, 16314, 16339,
    16364, 16389, 16414, 16440, 16465, 16490, 16515, 16540, 16565, 16590, 16616,
    16641, 16666, 16691, 16716, 16741, 16766, 16791, 16817, 16842, 16867, 16892,
    16917, 16942, 16967, 16992, 17018, 17043, 17068, 17093, 17118, 17143, 17168,
    17193, 17218, 17244, 17269, 17294, 17319, 17344, 17369, 17394, 17419, 17444,
    17469, 17495, 17520, 17545, 17570, 17595, 17620, 17645, 17670, 17695, 17720,
    17745, 17770, 17795, 17820, 17845, 17870, 17895, 17920, 17945, 17970, 17996,
    18021, 18046, 18071, 18096, 18121, 18146, 18171, 18196, 18220, 18245, 18270,
    18295, 18320, 18345, 18370, 18395, 18420, 18445, 18470, 18495, 18520, 18545,
    18570, 18595, 18620, 18644, 18669, 18694, 18719, 18744, 18769, 18794, 18819,
    18843, 18868, 18893, 18918, 18943, 18968, 18992, 19017, 19042, 19067, 19092,
    19116, 19141, 19166, 19191, 19216, 19240, 19265, 19290, 19315, 19339, 19364,
    19389, 19413, 19438, 19463, 19488, 19512, 19537, 19562, 19586, 19611, 19635,
    19660, 19685, 19709, 19734, 19759, 19783, 19808, 19832, 19857, 19881, 19906,
    19931, 19955, 19980, 20004, 20029, 20053, 20078, 20102, 20127, 20151, 20176,
    20200, 20224, 20249, 20273, 20298, 20322, 20347, 20371, 20395, 20420, 20444,
    20468, 20493, 20517, 20541, 20566, 20590, 20614, 20639, 20663, 20687, 20711,
    20736, 20760, 20784, 20808, 20832, 20857, 20881, 20905, 20929, 20953, 20977,
    21002, 21026, 21050, 21074, 21098, 21122, 21146, 21170, 21194, 21218, 21242,
    21266, 21290, 21314, 21338, 21362, 21386, 21410, 21434, 21458, 21482, 21506,
    21529, 21553, 21577, 21601, 21625, 21649, 21672, 21696, 21720, 21744, 21767,
    21791, 21815, 21839, 21862, 21886, 21910, 21933, 21957, 21981, 22004, 22028,
    22051, 22075, 22099, 22122, 22146, 22169, 22193, 22216, 22240, 22263, 22287,
    22310, 22333, 22357, 22380, 22404, 22427, 22450, 22474, 22497, 22520, 22544,
    22567, 22590, 22613, 22637, 22660, 22683, 22706, 22730, 22753, 22776, 22799,
    22822, 22845, 22868, 22891, 22914, 22938, 22961, 22984, 23007, 23030, 23053,
    23075, 23098, 23121, 23144, 23167, 23190, 23213, 23236, 23259, 23281, 23304,
    23327, 23350, 23372, 23395, 23418, 23441, 23463, 23486, 23509, 23531, 23554,
    23576, 23599, 23621, 23644, 23667, 23689, 23712, 23734, 23756, 23779, 23801,
    23824, 23846, 23869, 23891, 23913, 23936, 23958, 23980, 24002, 24025, 24047,
    24069, 24091, 24113, 24136, 24158, 24180, 24202, 24224, 24246, 24268, 24290,
    24312, 24334, 24356, 24378, 24400, 24422, 24444, 24466, 24488, 24509, 24531,
    24553, 24575, 24597, 24618, 24640, 24662, 24683, 24705, 24727, 24748, 24770,
    24791, 24813, 24835, 24856, 24878, 24899, 24921, 24942, 24963, 24985, 25006,
    25028, 25049, 25070, 25092, 25113, 25134, 25155, 25177, 25198, 25219, 25240,
    25261, 25282, 25303, 25325, 25346, 25367, 25388, 25409, 25430, 25451, 25471,
    25492, 25513, 25534, 25555, 25576, 25597, 25617, 25638, 25659, 25680, 25700,
    25721, 25742, 25762, 25783, 25803, 25824, 25844, 25865, 25885, 25906, 25926,
    25947, 25967, 25988, 26008, 26028, 26049, 26069, 26089, 26109, 26130, 26150,
    26170, 26190, 26210, 26230, 26250, 26270, 26290, 26310, 26330, 26350, 26370,
    26390, 26410, 26430, 26450, 26470, 26489, 26509, 26529, 26549, 26568, 26588,
    26608, 26627, 26647, 26667, 26686, 26706, 26725, 26745, 26764, 26784, 26803,
    26822, 26842, 26861, 26880, 26900, 26919, 26938, 26957, 26977, 26996, 27015,
    27034, 27053, 27072, 27091, 27110, 27129, 27148, 27167, 27186, 27205, 27224,
    27243, 27261, 27280, 27299, 27318, 27336, 27355, 27374, 27392, 27411, 27430,
    27448, 27467, 27485, 27504, 27522, 27540, 27559, 27577, 27596, 27614, 27632,
    27650, 27669, 27687, 27705, 27723, 27741, 27759, 27777, 27796, 27814, 27832,
    27850, 27867, 27885, 27903, 27921, 27939, 27957, 27975, 27992, 28010, 28028,
    28045, 28063, 28081, 28098, 28116, 28133, 28151, 28168, 28186, 28203, 28221,
    28238, 28255, 28273, 28290, 28307, 28324, 28342, 28359, 28376, 28393, 28410,
    28427, 28444, 28461, 28478, 28495, 28512, 28529, 28546, 28563, 28579, 28596,
    28613, 28630, 28646, 28663, 28680, 28696, 28713, 28729, 28746, 28762, 28779,
    28795, 28811, 28828, 28844, 28860, 28877, 28893, 28909, 28925, 28942, 28958,
    28974, 28990, 29006, 29022, 29038, 29054, 29070, 29086, 29102, 29117, 29133,
    29149, 29165, 29180, 29196, 29212, 29227, 29243, 29258, 29274, 29290, 29305,
    29320, 29336, 29351, 29367, 29382, 29397, 29412, 29428, 29443, 29458, 29473,
    29488, 29503, 29518, 29533, 29548, 29563, 29578, 29593, 29608, 29623, 29638,
    29652, 29667, 29682, 29696, 29711, 29726, 29740, 29755, 29769, 29784, 29798,
    29813, 29827, 29841, 29856, 29870, 29884, 29898, 29913, 29927, 29941, 29955,
    29969, 29983, 29997, 30011, 30025, 30039, 30053, 30067, 30080, 30094, 30108,
    30122, 30135, 30149, 30163, 30176, 30190, 30203, 30217, 30230, 30244, 30257,
    30270, 30284, 30297, 30310, 30323, 30337, 30350, 30363, 30376, 30389, 30402,
    30415, 30428, 30441, 30454, 30467, 30480, 30492, 30505, 30518, 30531, 30543,
    30556, 30568, 30581, 30593, 30606, 30618, 30631, 30643, 30656, 30668, 30680,
    30692, 30705, 30717, 30729, 30741, 30753, 30765, 30777, 30789, 30801, 30813,
    30825, 30837, 30849, 30861, 30872, 30884, 30896, 30907, 30919, 30931, 30942,
    30954, 30965, 30977, 30988, 30999, 31011, 31022, 31033, 31044, 31056, 31067,
    31078, 31089, 31100, 31111, 31122, 31133, 31144, 31155, 31166, 31177, 31187,
    31198, 31209, 31220, 31230, 31241, 31251, 31262, 31272, 31283, 31293, 31304,
    31314, 31324, 31335, 31345, 31355, 31365, 31376, 31386, 31396, 31406, 31416,
    31426, 31436, 31446, 31455, 31465, 31475, 31485, 31495, 31504, 31514, 31524,
    31533, 31543, 31552, 31562, 31571, 31581, 31590, 31599, 31609, 31618, 31627,
    31636, 31645, 31655, 31664, 31673, 31682, 31691, 31700, 31709, 31717, 31726,
    31735, 31744, 31752, 31761, 31770, 31778, 31787, 31796, 31804, 31813, 31821,
    31829, 31838, 31846, 31854, 31863, 31871, 31879, 31887, 31895, 31903, 31911,
    31919, 31927, 31935, 31943, 31951, 31959, 31967, 31974, 31982, 31990, 31997,
    32005, 32012, 32020, 32027, 32035, 32042, 32050, 32057, 32064, 32072, 32079,
    32086, 32093, 32100, 32107, 32114, 32121, 32128, 32135, 32142, 32149, 32156,
    32163, 32169, 32176, 32183, 32189, 32196, 32203, 32209, 32216, 32222, 32228,
    32235, 32241, 32247, 32254, 32260, 32266, 32272, 32278, 32284, 32290, 32296,
    32302, 32308, 32314, 32320, 32326, 32332, 32337, 32343, 32349, 32354, 32360,
    32365, 32371, 32376, 32382, 32387, 32393, 32398, 32403, 32408, 32414, 32419,
    32424, 32429, 32434, 32439, 32444, 32449, 32454, 32459, 32464, 32468, 32473,
    32478, 32483, 32487, 32492, 32496, 32501, 32505, 32510, 32514, 32519, 32523,
    32527, 32532, 32536, 32540, 32544, 32548, 32552, 32556, 32560, 32564, 32568,
    32572, 32576, 32580, 32584, 32587, 32591, 32595, 32598, 32602, 32605, 32609,
    32612, 32616, 32619, 32622, 32626, 32629, 32632, 32635, 32639, 32642, 32645,
    32648, 32651, 32654, 32657, 32660, 32662, 32665, 32668, 32671, 32673, 32676,
    32679, 32681, 32684, 32686, 32689, 32691, 32694, 32696, 32698, 32701, 32703,
    32705, 32707, 32709, 32711, 32713, 32715, 32717, 32719, 32721, 32723, 32725,
    32727, 32728, 32730, 32732, 32733, 32735, 32736, 32738, 32739, 32741, 32742,
    32744, 32745, 32746, 32747, 32749, 32750, 32751, 32752, 32753, 32754, 32755,
    32756, 32757, 32758, 32758, 32759, 32760, 32761, 32761, 32762, 32762, 32763,
    32763, 32764, 32764, 32765, 32765, 32765, 32766, 32766, 32766, 32766, 32766,
    32766, 32766, 32766, 32766, 32766, 32766, 32766, 32766, 32766, 32765, 32765,
    32765, 32764, 32764, 32763, 32763, 32762, 32762, 32761, 32761, 32760, 32759,
    32758, 32758, 32757, 32756, 32755, 32754, 32753, 32752, 32751, 32750, 32749,
    32747, 32746, 32745, 32744, 32742, 32741, 32739, 32738, 32736, 32735, 32733,
    32732, 32730, 32728, 32727, 32725, 32723, 32721, 32719, 32717, 32715, 32713,
    32711, 32709, 32707, 32705, 32703, 32701, 32698, 32696, 32694, 32691, 32689,
    32686, 32684, 32681, 32679, 32676, 32673, 32671, 32668, 32665, 32662, 32660,
    32657, 32654, 32651, 32648, 32645, 32642, 32639, 32635, 32632, 32629, 32626,
    32622, 32619, 32616, 32612, 32609, 32605, 32602, 32598, 32595, 32591, 32587,
    32584, 32580, 32576, 32572, 32568, 32564, 32560, 32556, 32552, 32548, 32544,
    32540, 32536, 32532, 32527, 32523, 32519, 32514, 32510, 32505, 32501, 32496,
    32492, 32487, 32483, 32478, 32473, 32468, 32464, 32459, 32454, 32449, 32444,
    32439, 32434, 32429, 32424, 32419, 32414, 32408, 32403, 32398, 32393, 32387,
    32382, 32376, 32371, 32365, 32360, 32354, 32349, 32343, 32337, 32332, 32326,
    32320, 32314, 32308, 32302, 32296, 32290, 32284, 32278, 32272, 32266, 32260,
    32254, 32247, 32241, 32235, 32228, 32222, 32216, 32209, 32203, 32196, 32189,
    32183, 32176, 32169, 32163, 32156, 32149, 32142, 32135, 32128, 32121, 32114,
    32107, 32100, 32093, 32086, 32079, 32072, 32064, 32057, 32050, 32042, 32035,
    32027, 32020, 32012, 32005, 31997, 31990, 31982, 31974, 31967, 31959, 31951,
    31943, 31935, 31927, 31919, 31911, 31903, 31895, 31887, 31879, 31871, 31863,
    31854, 31846, 31838, 31829, 31821, 31813, 31804, 31796, 31787, 31778, 31770,
    31761, 31752, 31744, 31735, 31726, 31717, 31709, 31700, 31691, 31682, 31673,
    31664, 31655, 31645, 31636, 31627, 31618, 31609, 31599, 31590, 31581, 31571,
    31562, 31552, 31543, 31533, 31524, 31514, 31504, 31495, 31485, 31475, 31465,
    31455, 31446, 31436, 31426, 31416, 31406, 31396, 31386, 31376, 31365, 31355,
    31345, 31335, 31324, 31314, 31304, 31293, 31283, 31272, 31262, 31251, 31241,
    31230, 31220, 31209, 31198, 31187, 31177, 31166, 31155, 31144, 31133, 31122,
    31111, 31100, 31089, 31078, 31067, 31056, 31044, 31033, 31022, 31011, 30999,
    30988, 30977, 30965, 30954, 30942, 30931, 30919, 30907, 30896, 30884, 30872,
    30861, 30849, 30837, 30825, 30813, 30801, 30789, 30777, 30765, 30753, 30741,
    30729, 30717, 30705, 30692, 30680, 30668, 30656, 30643, 30631, 30618, 30606,
    30593, 30581, 30568, 30556, 30543, 30531, 30518, 30505, 30492, 30480, 30467,
    30454, 30441, 30428, 30415, 30402, 30389, 30376, 30363, 30350, 30337, 30323,
    30310, 30297, 30284, 30270, 30257, 30244, 30230, 30217, 30203, 30190, 30176,
    30163, 30149, 30135, 30122, 30108, 30094, 30080, 30067, 30053, 30039, 30025,
    30011, 29997, 29983, 29969, 29955, 29941, 29927, 29913, 29898, 29884, 29870,
    29856, 29841, 29827, 29813, 29798, 29784, 29769, 29755, 29740, 29726, 29711,
    29696, 29682, 29667, 29652, 29638, 29623, 29608, 29593, 29578, 29563, 29548,
    29533, 29518, 29503, 29488, 29473, 29458, 29443, 29428, 29412, 29397, 29382,
    29367, 29351, 29336, 29320, 29305, 29290, 29274, 29258, 29243, 29227, 29212,
    29196, 29180, 29165, 29149, 29133, 29117, 29102, 29086, 29070, 29054, 29038,
    29022, 29006, 28990, 28974, 28958, 28942, 28925, 28909, 28893, 28877, 28860,
    28844, 28828, 28811, 28795, 28779, 28762, 28746, 28729, 28713, 28696, 28680,
    28663, 28646, 28630, 28613, 28596, 28579, 28563, 28546, 28529, 28512, 28495,
    28478, 28461, 28444, 28427, 28410, 28393, 28376, 28359, 28342, 28324, 28307,
    28290, 28273, 28255, 28238, 28221, 28203, 28186, 28168, 28151, 28133, 28116,
    28098, 28081, 28063, 28045, 28028, 28010, 27992, 27975, 27957, 27939, 27921,
    27903, 27885, 27867, 27850, 27832, 27814, 27796, 27777, 27759, 27741, 27723,
    27705, 27687, 27669, 27650, 27632, 27614, 27596, 27577, 27559, 27540, 27522,
    27504, 27485, 27467, 27448, 27430, 27411, 27392, 27374, 27355, 27336, 27318,
    27299, 27280, 27261, 27243, 27224, 27205, 27186, 27167, 27148, 27129, 27110,
    27091, 27072, 27053, 27034, 27015, 26996, 26977, 26957, 26938, 26919, 26900,
    26880, 26861, 26842, 26822, 26803, 26784, 26764, 26745, 26725, 26706, 26686,
    26667, 26647, 26627, 26608, 26588, 26568, 26549, 26529, 26509, 26489, 26470,
    26450, 26430, 26410, 26390, 26370, 26350, 26330, 26310, 26290, 26270, 26250,
    26230, 26210, 26190, 26170, 26150, 26130, 26109, 26089, 26069, 26049, 26028,
    26008, 25988, 25967, 25947, 25926, 25906, 25885, 25865, 25844, 25824, 25803,
    25783, 25762, 25742, 25721, 25700, 25680, 25659, 25638, 25617, 25597, 25576,
    25555, 25534, 25513, 25492, 25471, 25451, 25430, 25409, 25388, 25367, 25346,
    25325, 25303, 25282, 25261, 25240, 25219, 25198, 25177, 25155, 25134, 25113,
    25092, 25070, 25049, 25028, 25006, 24985, 24963, 24942, 24921, 24899, 24878,
    24856, 24835, 24813, 24791, 24770, 24748, 24727, 24705, 24683, 24662, 24640,
    24618, 24597, 24575, 24553, 24531, 24509, 24488, 24466, 24444, 24422, 24400,
    24378, 24356, 24334, 24312, 24290, 24268, 24246, 24224, 24202, 24180, 24158,
    24136, 24113, 24091, 24069, 24047, 24025, 24002, 23980, 23958, 23936, 23913,
    23891, 23869, 23846, 23824, 23801, 23779, 23756, 23734, 23712, 23689, 23667,
    23644, 23621, 23599, 23576, 23554, 23531, 23509, 23486, 23463, 23441, 23418,
    23395, 23372, 23350, 23327, 23304, 23281, 23259, 23236, 23213, 23190, 23167,
    23144, 23121, 23098, 23075, 23053, 23030, 23007, 22984, 22961, 22938, 22914,
    22891, 22868, 22845, 22822, 22799, 22776, 22753, 22730, 22706, 22683, 22660,
    22637, 22613, 22590, 22567, 22544, 22520, 22497, 22474, 22450, 22427, 22404,
    22380, 22357, 22333, 22310, 22287, 22263, 22240, 22216, 22193, 22169, 22146,
    22122, 22099, 22075, 22051, 22028, 22004, 21981, 21957, 21933, 21910, 21886,
    21862, 21839, 21815, 21791, 21767, 21744, 21720, 21696, 21672, 21649, 21625,
    21601, 21577, 21553, 21529, 21506, 21482, 21458, 21434, 21410, 21386, 21362,
    21338, 21314, 21290, 21266, 21242, 21218, 21194, 21170, 21146, 21122, 21098,
    21074, 21050, 21026, 21002, 20977, 20953, 20929, 20905, 20881, 20857, 20832,
    20808, 20784, 20760, 20736, 20711, 20687, 20663, 20639, 20614, 20590, 20566,
    20541, 20517, 20493, 20468, 20444, 20420, 20395, 20371, 20347, 20322, 20298,
    20273, 20249, 20224, 20200, 20176, 20151, 20127, 20102, 20078, 20053, 20029,
    20004, 19980, 19955, 19931, 19906, 19881, 19857, 19832, 19808, 19783, 19759,
    19734, 19709, 19685, 19660, 19635, 19611, 19586, 19562, 19537, 19512, 19488,
    19463, 19438, 19413, 19389, 19364, 19339, 19315, 19290, 19265, 19240, 19216,
    19191, 19166, 19141, 19116, 19092, 19067, 19042, 19017, 18992, 18968, 18943,
    18918, 18893, 18868, 18843, 18819, 18794, 18769, 18744, 18719, 18694, 18669,
    18644, 18620, 18595, 18570, 18545, 18520, 18495, 18470, 18445, 18420, 18395,
    18370, 18345, 18320, 18295, 18270, 18245, 18220, 18196, 18171, 18146, 18121,
    18096, 18071, 18046, 18021, 17996, 17970, 17945, 17920, 17895, 17870, 17845,
    17820, 17795, 17770, 17745, 17720, 17695, 17670, 17645, 17620, 17595, 17570,
    17545, 17520, 17495, 17469, 17444, 17419, 17394, 17369, 17344, 17319, 17294,
    17269, 17244, 17218, 17193, 17168, 17143, 17118, 17093, 17068, 17043, 17018,
    16992, 16967, 16942, 16917, 16892, 16867, 16842, 16817, 16791, 16766, 16741,
    16716, 16691, 16666, 16641, 16616, 16590, 16565, 16540, 16515, 16490, 16465,
    16440, 16414, 16389, 16364, 16339, 16314, 16289, 16264, 16238, 16213, 16188,
    16163, 16138, 16113, 16088, 16063, 16037, 16012, 15987, 15962, 15937, 15912,
    15887, 15861, 15836, 15811, 15786, 15761, 15736, 15711, 15686, 15661, 15635,
    15610, 15585, 15560, 15535, 15510, 15485, 15460, 15435, 15409, 15384, 15359,
    15334, 15309, 15284, 15259, 15234, 15209, 15184, 15159, 15134, 15109, 15083,
    15058, 15033, 15008, 14983, 14958, 14933, 14908, 14883, 14858, 14833, 14808,
    14783, 14758, 14733, 14708, 14683, 14658, 14633, 14608, 14583, 14558, 14533,
    14508, 14483, 14458, 14433, 14408, 14383, 14358, 14333, 14308, 14283, 14259,
    14234, 14209, 14184, 14159, 14134, 14109, 14084, 14059, 14034, 14010, 13985,
    13960, 13935, 13910, 13885, 13860, 13836, 13811, 13786, 13761, 13736, 13711,
    13687, 13662, 13637, 13612, 13588, 13563, 13538, 13513, 13489, 13464, 13439,
    13414, 13390, 13365, 13340, 13316, 13291, 13266, 13241, 13217, 13192, 13167,
    13143, 13118, 13094, 13069, 13044, 13020, 12995, 12971, 12946, 12921, 12897,
    12872, 12848, 12823, 12799, 12774, 12750, 12725, 12701, 12676, 12652, 12627,
    12603, 12578, 12554, 12529, 12505, 12480, 12456, 12432, 12407, 12383, 12359,
    12334, 12310, 12285, 12261, 12237, 12212, 12188, 12164, 12140, 12115, 12091,
    12067, 12043, 12018, 11994, 11970, 11946, 11921, 11897, 11873, 11849, 11825,
    11801, 11777, 11752, 11728, 11704, 11680, 11656, 11632, 11608, 11584, 11560,
    11536, 11512, 11488, 11464, 11440, 11416, 11392, 11368, 11344, 11320, 11296,
    11272, 11249, 11225, 11201, 11177, 11153, 11129, 11106, 11082, 11058, 11034,
    11010, 10987, 10963, 10939, 10916, 10892, 10868, 10845, 10821, 10797, 10774,
    10750, 10726, 10703, 10679, 10656, 10632, 10609, 10585, 10562, 10538, 10515,
    10491, 10468, 10444, 10421, 10397, 10374, 10351, 10327, 10304, 10281, 10257,
    10234, 10211, 10187, 10164, 10141, 10118, 10094, 10071, 10048, 10025, 10002,
    9979,  9955,  9932,  9909,  9886,  9863,  9840,  9817,  9794,  9771,  9748,
    9725,  9702,  9679,  9656,  9633,  9610,  9587,  9565,  9542,  9519,  9496,
    9473,  9450,  9428,  9405,  9382,  9360,  9337,  9314,  9291,  9269,  9246,
    9224,  9201,  9178,  9156,  9133,  9111,  9088,  9066,  9043,  9021,  8998,
    8976,  8953,  8931,  8909,  8886,  8864,  8842,  8819,  8797,  8775,  8753,
    8730,  8708,  8686,  8664,  8642,  8619,  8597,  8575,  8553,  8531,  8509,
    8487,  8465,  8443,  8421,  8399,  8377,  8355,  8333,  8311,  8289,  8268,
    8246,  8224,  8202,  8180,  8159,  8137,  8115,  8093,  8072,  8050,  8029,
    8007,  7985,  7964,  7942,  7921,  7899,  7878,  7856,  7835,  7813,  7792,
    7770,  7749,  7728,  7706,  7685,  7664,  7643,  7621,  7600,  7579,  7558,
    7536,  7515,  7494,  7473,  7452,  7431,  7410,  7389,  7368,  7347,  7326,
    7305,  7284,  7263,  7242,  7221,  7201,  7180,  7159,  7138,  7118,  7097,
    7076,  7055,  7035,  7014,  6994,  6973,  6952,  6932,  6911,  6891,  6870,
    6850,  6829,  6809,  6789,  6768,  6748,  6728,  6707,  6687,  6667,  6647,
    6626,  6606,  6586,  6566,  6546,  6526,  6506,  6486,  6466,  6446,  6426,
    6406,  6386,  6366,  6346,  6326,  6306,  6286,  6267,  6247,  6227,  6207,
    6188,  6168,  6148,  6129,  6109,  6090,  6070,  6051,  6031,  6012,  5992,
    5973,  5953,  5934,  5915,  5895,  5876,  5857,  5837,  5818,  5799,  5780,
    5761,  5742,  5722,  5703,  5684,  5665,  5646,  5627,  5608,  5589,  5571,
    5552,  5533,  5514,  5495,  5476,  5458,  5439,  5420,  5402,  5383,  5364,
    5346,  5327,  5309,  5290,  5272,  5253,  5235,  5216,  5198,  5180,  5161,
    5143,  5125,  5106,  5088,  5070,  5052,  5034,  5016,  4998,  4979,  4961,
    4943,  4925,  4907,  4890,  4872,  4854,  4836,  4818,  4800,  4783,  4765,
    4747,  4729,  4712,  4694,  4677,  4659,  4641,  4624,  4606,  4589,  4572,
    4554,  4537,  4519,  4502,  4485,  4468,  4450,  4433,  4416,  4399,  4382,
    4364,  4347,  4330,  4313,  4296,  4279,  4263,  4246,  4229,  4212,  4195,
    4178,  4162,  4145,  4128,  4111,  4095,  4078,  4062,  4045,  4029,  4012,
    3996,  3979,  3963,  3946,  3930,  3914,  3897,  3881,  3865,  3849,  3833,
    3816,  3800,  3784,  3768,  3752,  3736,  3720,  3704,  3688,  3672,  3657,
    3641,  3625,  3609,  3593,  3578,  3562,  3546,  3531,  3515,  3500,  3484,
    3469,  3453,  3438,  3422,  3407,  3392,  3376,  3361,  3346,  3331,  3316,
    3300,  3285,  3270,  3255,  3240,  3225,  3210,  3195,  3180,  3166,  3151,
    3136,  3121,  3106,  3092,  3077,  3062,  3048,  3033,  3019,  3004,  2990,
    2975,  2961,  2946,  2932,  2918,  2903,  2889,  2875,  2860,  2846,  2832,
    2818,  2804,  2790,  2776,  2762,  2748,  2734,  2720,  2706,  2692,  2679,
    2665,  2651,  2638,  2624,  2610,  2597,  2583,  2570,  2556,  2543,  2529,
    2516,  2502,  2489,  2476,  2462,  2449,  2436,  2423,  2410,  2397,  2383,
    2370,  2357,  2344,  2332,  2319,  2306,  2293,  2280,  2267,  2255,  2242,
    2229,  2217,  2204,  2191,  2179,  2166,  2154,  2141,  2129,  2117,  2104,
    2092,  2080,  2067,  2055,  2043,  2031,  2019,  2007,  1995,  1983,  1971,
    1959,  1947,  1935,  1923,  1911,  1900,  1888,  1876,  1864,  1853,  1841,
    1830,  1818,  1807,  1795,  1784,  1772,  1761,  1750,  1738,  1727,  1716,
    1705,  1694,  1682,  1671,  1660,  1649,  1638,  1627,  1617,  1606,  1595,
    1584,  1573,  1563,  1552,  1541,  1531,  1520,  1509,  1499,  1488,  1478,
    1467,  1457,  1447,  1436,  1426,  1416,  1406,  1396,  1385,  1375,  1365,
    1355,  1345,  1335,  1325,  1315,  1306,  1296,  1286,  1276,  1267,  1257,
    1247,  1238,  1228,  1219,  1209,  1200,  1190,  1181,  1171,  1162,  1153,
    1144,  1134,  1125,  1116,  1107,  1098,  1089,  1080,  1071,  1062,  1053,
    1044,  1035,  1027,  1018,  1009,  1000,  992,   983,   975,   966,   958,
    949,   941,   932,   924,   916,   908,   899,   891,   883,   875,   867,
    859,   851,   843,   835,   827,   819,   811,   803,   796,   788,   780,
    772,   765,   757,   750,   742,   735,   727,   720,   713,   705,   698,
    691,   684,   676,   669,   662,   655,   648,   641,   634,   627,   620,
    614,   607,   600,   593,   587,   580,   573,   567,   560,   554,   547,
    541,   534,   528,   522,   515,   509,   503,   497,   491,   485,   479,
    473,   467,   461,   455,   449,   443,   437,   432,   426,   420,   414,
    409,   403,   398,   392,   387,   381,   376,   371,   365,   360,   355,
    350,   345,   339,   334,   329,   324,   319,   314,   310,   305,   300,
    295,   290,   286,   281,   276,   272,   267,   263,   258,   254,   249,
    245,   241,   237,   232,   228,   224,   220,   216,   212,   208,   204,
    200,   196,   192,   188,   184,   181,   177,   173,   170,   166,   162,
    159,   155,   152,   149,   145,   142,   139,   135,   132,   129,   126,
    123,   120,   117,   114,   111,   108,   105,   102,   99,    97,    94,
    91,    89,    86,    83,    81,    78,    76,    74,    71,    69,    67,
    64,    62,    60,    58,    56,    54,    52,    50,    48,    46,    44,
    42,    40,    39,    37,    35,    34,    32,    30,    29,    27,    26,
    24,    23,    22,    20,    19,    18,    17,    16,    15,    14,    13,
    12,    11,    10,    9,     8,     7,     6,     6,     5,     4,     4,
    3,     3,     2,     2,     1,     1,     1,     0,     0,     0,     0,
    0,     0,     0,     0,
};
